/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.latke.repository.h2;

import java.sql.Connection;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.b3log.latke.repository.h2.mapping.BooleanMapping;
import org.b3log.latke.repository.h2.mapping.StringMapping;
import org.b3log.latke.repository.jdbc.AbstractJdbcDatabaseSolution;
import org.b3log.latke.repository.jdbc.mapping.DateMapping;
import org.b3log.latke.repository.jdbc.mapping.IntMapping;
import org.b3log.latke.repository.jdbc.mapping.LongMapping;
import org.b3log.latke.repository.jdbc.mapping.Mapping;
import org.b3log.latke.repository.jdbc.mapping.NumberMapping;
import org.b3log.latke.repository.jdbc.util.Connections;
import org.b3log.latke.repository.jdbc.util.FieldDefinition;
import org.b3log.latke.repository.jdbc.util.RepositoryDefinition;

public final class H2JdbcDatabaseSolution
extends AbstractJdbcDatabaseSolution {
    private static final Logger LOGGER = LogManager.getLogger(H2JdbcDatabaseSolution.class);

    public H2JdbcDatabaseSolution() {
        this.registerType("int", (Mapping)new IntMapping());
        this.registerType("boolean", new BooleanMapping());
        this.registerType("long", (Mapping)new LongMapping());
        this.registerType("double", (Mapping)new NumberMapping());
        this.registerType("String", new StringMapping());
        this.registerType("Date", (Mapping)new DateMapping());
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public boolean existTable(String tableName) {
        try {
            Connection connection = Connections.getConnection();
            try {
                boolean bl;
                block20: {
                    Statement statement = connection.createStatement();
                    try {
                        try {
                            statement.execute("SELECT 1 FROM `" + tableName + "` LIMIT 1");
                        }
                        catch (Throwable e) {
                            boolean bl2 = false;
                            if (statement != null) {
                                statement.close();
                            }
                            if (connection != null) {
                                connection.close();
                            }
                            return bl2;
                        }
                    }
                    catch (Throwable throwable) {
                        if (statement != null) {
                            try {
                                statement.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    bl = true;
                    if (statement == null) break block20;
                    statement.close();
                }
                return bl;
            }
            finally {
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (Throwable throwable) {
                        Throwable throwable3;
                        throwable3.addSuppressed(throwable);
                    }
                }
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.ERROR, "Checks table [" + tableName + "] existence failed, assumed it existing [true]", (Throwable)e);
            return true;
        }
    }

    public String queryPage(int start, int end, String selectSql, String filterSql, String orderBySql, String tableName) {
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append(selectSql).append(" FROM ").append(tableName);
        if (StringUtils.isNotBlank((CharSequence)filterSql)) {
            sqlBuilder.append(" WHERE ").append(filterSql);
        }
        sqlBuilder.append(orderBySql);
        sqlBuilder.append(" LIMIT ").append(start).append(",").append(end - start);
        return sqlBuilder.toString();
    }

    public String getRandomlySql(String tableName, int fetchSize) {
        return "SELECT * FROM " + tableName + " ORDER BY RAND() LIMIT " + fetchSize;
    }

    protected void createTableHead(StringBuilder createTableSqlBuilder, RepositoryDefinition repositoryDefinition) {
        createTableSqlBuilder.append("CREATE TABLE IF NOT EXISTS ").append(repositoryDefinition.getName()).append("(");
    }

    protected void createTableBody(StringBuilder createTableSqlBuilder, RepositoryDefinition repositoryDefinition) {
        ArrayList<FieldDefinition> keyDefinitionList = new ArrayList<FieldDefinition>();
        for (FieldDefinition fieldDefinition : repositoryDefinition.getKeys()) {
            String type = fieldDefinition.getType();
            if (type == null) {
                throw new RuntimeException("the type of fieldDefinitions should not be null");
            }
            Mapping mapping = (Mapping)this.getJdbcTypeMapping().get(type);
            if (mapping != null) {
                createTableSqlBuilder.append(mapping.toDataBaseString(fieldDefinition)).append(", ");
                if (!fieldDefinition.getIsKey().booleanValue()) continue;
                keyDefinitionList.add(fieldDefinition);
                continue;
            }
            throw new RuntimeException("The type [" + fieldDefinition.getType() + "] is not register for mapping ");
        }
        this.createSoftDeleteField(createTableSqlBuilder);
        createTableSqlBuilder.append(this.createKeyDefinition(keyDefinitionList));
    }

    private String createKeyDefinition(List<FieldDefinition> keyDefinitionList) {
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append(" PRIMARY KEY");
        boolean isFirst = true;
        for (FieldDefinition fieldDefinition : keyDefinitionList) {
            if (isFirst) {
                sqlBuilder.append("(");
                isFirst = false;
            } else {
                sqlBuilder.append(",");
            }
            sqlBuilder.append(fieldDefinition.getName());
        }
        sqlBuilder.append(")");
        return sqlBuilder.toString();
    }

    protected void createTableEnd(StringBuilder createTableSqlBuilder, RepositoryDefinition repositoryDefinition) {
        createTableSqlBuilder.append(")");
    }
}

