/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.latke.util;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.b3log.latke.util.URLs;

public final class UriTemplates {
    public static Map<String, String> resolve(String uri, String uriTemplate) {
        String[] templateParts;
        String[] parts = URLs.decode(uri).split("/");
        if (parts.length != (templateParts = uriTemplate.split("/")).length) {
            return null;
        }
        HashMap<String, String> ret = new HashMap<String, String>();
        for (int i = 0; i < parts.length; ++i) {
            String part = parts[i];
            String templatePart = templateParts[i];
            if (part.equals(templatePart)) continue;
            String name = StringUtils.substringBetween((String)templatePart, (String)"{", (String)"}");
            if (StringUtils.isBlank((CharSequence)name)) {
                return null;
            }
            String templatePartTmp = StringUtils.replace((String)templatePart, (String)("{" + name + "}"), (String)"");
            String arg = StringUtils.replace((String)part, (String)templatePartTmp, (String)"");
            ret.put(name, arg);
        }
        return ret;
    }

    private UriTemplates() {
    }
}

