/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.latke.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public final class Strings {
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final int MAX_EMAIL_LENGTH_LOCAL = 64;
    private static final int MAX_EMAIL_LENGTH_DOMAIN = 255;
    private static final int MAX_EMAIL_LENGTH = 256;
    private static final Pattern EMAIL_PATTERN = Pattern.compile("^[_A-Za-z0-9-\\+]+(\\.[_A-Za-z0-9-]+)*@[A-Za-z0-9-]+(\\.[A-Za-z0-9]+)*(\\.[A-Za-z]{2,})$");

    private Strings() {
    }

    public static boolean isIPv4(String ip) {
        if (StringUtils.isBlank((CharSequence)ip)) {
            return false;
        }
        String regex = "^(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)$";
        Pattern pattern = Pattern.compile("^(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)$");
        Matcher matcher = pattern.matcher(ip);
        return matcher.matches();
    }

    public static List<String> toLines(String string) throws IOException {
        if (null == string) {
            return null;
        }
        ArrayList<String> ret = new ArrayList<String>();
        try (BufferedReader bufferedReader = new BufferedReader(new StringReader(string));){
            String line = bufferedReader.readLine();
            while (null != line) {
                ret.add(line);
                line = bufferedReader.readLine();
            }
        }
        return ret;
    }

    public static boolean isNumeric(String string) {
        try {
            Double.parseDouble(string);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static boolean isInteger(String string) {
        try {
            Integer.parseInt(string);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static boolean isEmail(String string) {
        if (StringUtils.isBlank((CharSequence)string)) {
            return false;
        }
        if (256 < string.length()) {
            return false;
        }
        String[] parts = string.split("@");
        if (2 != parts.length) {
            return false;
        }
        String local = parts[0];
        if (64 < local.length()) {
            return false;
        }
        String domain = parts[1];
        if (255 < domain.length()) {
            return false;
        }
        return EMAIL_PATTERN.matcher(string).matches();
    }

    public static String[] trimAll(String[] strings) {
        if (null == strings) {
            return null;
        }
        return (String[])Arrays.stream(strings).map(StringUtils::trim).toArray(String[]::new);
    }

    public static boolean containsIgnoreCase(String string, String[] strings) {
        if (null == strings) {
            return false;
        }
        return Arrays.stream(strings).anyMatch(str -> StringUtils.equalsIgnoreCase((CharSequence)string, (CharSequence)str));
    }

    public static boolean contains(String string, String[] strings) {
        if (null == strings) {
            return false;
        }
        return Arrays.stream(strings).anyMatch(str -> StringUtils.equals((CharSequence)string, (CharSequence)str));
    }

    public static boolean isURL(String string) {
        try {
            new URL(string);
            return true;
        }
        catch (MalformedURLException e) {
            return false;
        }
    }
}

