/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.latke.util;

import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.b3log.latke.Latkes;
import org.b3log.latke.http.Request;
import org.b3log.latke.http.Session;

public final class Locales {
    private static final Logger LOGGER = LogManager.getLogger(Locales.class);
    private static final ThreadLocal<Locale> LOCALE = new InheritableThreadLocal<Locale>();
    private static final int LANG_START = 0;
    private static final int LANG_END = 2;
    private static final int COUNTRY_START = 3;
    private static final int COUNTRY_END = 5;

    private Locales() {
    }

    public static Locale getLocale(Request request) {
        Locale locale = null;
        Session session = request.getSession();
        if (session != null) {
            locale = Locales.getLocale(session.getAttribute("locale"));
        }
        if (null == locale) {
            String languageHeader = request.getHeader("Accept-Language");
            LOGGER.log(Level.DEBUG, "[Accept-Language={}]", (Object)languageHeader);
            String language = "zh";
            String country = "CN";
            if (StringUtils.isNotBlank((CharSequence)languageHeader)) {
                language = Locales.getLanguage(languageHeader);
                country = Locales.getCountry(languageHeader);
            }
            if (!Locales.hasLocale(locale = new Locale(language, country))) {
                locale = Latkes.getLocale();
                LOGGER.log(Level.DEBUG, "Using the default locale[{}]", (Object)locale.toString());
            } else {
                LOGGER.log(Level.DEBUG, "Got locale[{}] from request.", (Object)locale.toString());
            }
        } else {
            LOGGER.log(Level.DEBUG, "Got locale[{}] from session.", (Object)locale.toString());
        }
        return locale;
    }

    public static boolean hasLocale(Locale locale) {
        try {
            ResourceBundle.getBundle("lang", locale);
            return true;
        }
        catch (MissingResourceException e) {
            return false;
        }
    }

    public static void setLocale(Request request, Locale locale) {
        Session session = request.getSession();
        if (null == session) {
            LOGGER.warn("Ignores set locale caused by no session");
            return;
        }
        session.setAttribute("locale", locale.toString());
        LOGGER.log(Level.DEBUG, "Client [sessionId={}] sets locale to [{}]", (Object)session.getId(), (Object)locale.toString());
    }

    public static void setLocale(Locale locale) {
        LOCALE.set(locale);
    }

    public static Locale getLocale() {
        Locale ret = LOCALE.get();
        if (null == ret) {
            return Latkes.getLocale();
        }
        return ret;
    }

    public static String getCountry(String localeString) {
        if (localeString.length() >= 5) {
            return localeString.substring(3, 5);
        }
        return "";
    }

    public static String getLanguage(String localeString) {
        if (localeString.length() >= 2) {
            return localeString.substring(0, 2);
        }
        return "";
    }

    public static Locale getLocale(String localeString) {
        if (StringUtils.isBlank((CharSequence)localeString)) {
            return null;
        }
        return new Locale(Locales.getLanguage(localeString), Locales.getCountry(localeString));
    }
}

