/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.latke.service;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.b3log.latke.Latkes;
import org.b3log.latke.ioc.Singleton;
import org.b3log.latke.util.Locales;

@Singleton
public class LangPropsService {
    private static final Logger LOGGER = LogManager.getLogger(LangPropsService.class);
    private static final Map<Locale, Map<String, String>> LANGS = new HashMap<Locale, Map<String, String>>();

    public Map<String, String> getAll(Locale locale) {
        Map<String, String> ret = LANGS.get(locale);
        if (null == ret) {
            ret = new HashMap<String, String>();
            ResourceBundle defaultLangBundle = ResourceBundle.getBundle("lang", Latkes.getLocale());
            Enumeration<String> defaultLangKeys = defaultLangBundle.getKeys();
            while (defaultLangKeys.hasMoreElements()) {
                String key = defaultLangKeys.nextElement();
                String value = this.replaceVars(defaultLangBundle.getString(key));
                ret.put(key, value);
            }
            ResourceBundle langBundle = ResourceBundle.getBundle("lang", locale);
            Enumeration<String> langKeys = langBundle.getKeys();
            while (langKeys.hasMoreElements()) {
                String key = langKeys.nextElement();
                String value = this.replaceVars(langBundle.getString(key));
                ret.put(key, value);
            }
            LANGS.put(locale, ret);
        }
        return ret;
    }

    public String get(String key) {
        return this.get("lang", key, Locales.getLocale());
    }

    public String get(String key, Locale locale) {
        return this.get("lang", key, locale);
    }

    private String get(String baseName, String key, Locale locale) {
        if (!"lang".equals(baseName)) {
            RuntimeException e = new RuntimeException("i18n resource [baseName=" + baseName + "] not found");
            LOGGER.log(Level.ERROR, e.getMessage(), (Throwable)e);
            throw e;
        }
        try {
            return this.replaceVars(ResourceBundle.getBundle(baseName, locale).getString(key));
        }
        catch (MissingResourceException e) {
            LOGGER.log(Level.WARN, "{}, get it from default locale [{}]", (Object)e.getMessage(), (Object)Latkes.getLocale());
            return this.replaceVars(ResourceBundle.getBundle(baseName, Latkes.getLocale()).getString(key));
        }
    }

    private String replaceVars(String langValue) {
        String ret = StringUtils.replace((String)langValue, (String)"${servePath}", (String)Latkes.getServePath());
        ret = StringUtils.replace((String)ret, (String)"${staticServePath}", (String)Latkes.getStaticServePath());
        return ret;
    }
}

