/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.latke.repository.jdbc.util;

import java.io.IOException;
import java.io.Reader;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.b3log.latke.Latkes;
import org.b3log.latke.repository.RepositoryException;
import org.b3log.latke.repository.jdbc.util.FieldDefinition;
import org.b3log.latke.repository.jdbc.util.JdbcRepositories;
import org.json.JSONObject;

public final class JdbcUtil {
    private static final Logger LOGGER = LogManager.getLogger(JdbcUtil.class);

    public static boolean executeSql(String sql, Connection connection, boolean isDebug) throws SQLException {
        Statement statement;
        if (isDebug || LOGGER.isTraceEnabled()) {
            LOGGER.log(Level.INFO, "Executing SQL [" + sql + "]");
        }
        boolean ret = !(statement = connection.createStatement()).execute(sql);
        statement.close();
        return ret;
    }

    public static boolean executeSql(String sql, List<Object> paramList, Connection connection, boolean isDebug) throws SQLException {
        if (isDebug || LOGGER.isTraceEnabled()) {
            LOGGER.log(Level.INFO, "Executing SQL [" + sql + "]");
        }
        PreparedStatement preparedStatement = connection.prepareStatement(sql);
        for (int i = 1; i <= paramList.size(); ++i) {
            preparedStatement.setObject(i, paramList.get(i - 1));
        }
        boolean ret = preparedStatement.execute();
        preparedStatement.close();
        return ret;
    }

    public static JSONObject queryJsonObject(String sql, List<Object> paramList, Connection connection, String tableName, boolean isDebug) throws Exception {
        return JdbcUtil.queryJson(sql, paramList, connection, true, tableName, isDebug);
    }

    public static List<JSONObject> queryListJson(String sql, List<Object> paramList, Connection connection, String tableName, boolean isDebug) throws Exception {
        JSONObject jsonObject = JdbcUtil.queryJson(sql, paramList, connection, false, tableName, isDebug);
        return (List)jsonObject.opt("rslts");
    }

    private static JSONObject queryJson(String sql, List<Object> paramList, Connection connection, boolean ifOnlyOne, String tableName, boolean isDebug) throws Exception {
        if (isDebug || LOGGER.isTraceEnabled()) {
            LOGGER.log(Level.INFO, "Executing SQL [" + sql + "]");
        }
        PreparedStatement preparedStatement = connection.prepareStatement(sql);
        for (int i = 1; i <= paramList.size(); ++i) {
            preparedStatement.setObject(i, paramList.get(i - 1));
        }
        ResultSet resultSet = preparedStatement.executeQuery();
        JSONObject ret = JdbcUtil.resultSetToJsonObject(resultSet, ifOnlyOne, tableName);
        resultSet.close();
        preparedStatement.close();
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static JSONObject resultSetToJsonObject(ResultSet resultSet, boolean ifOnlyOne, String tableName) throws Exception {
        JSONObject ret;
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        List<FieldDefinition> definitionList = JdbcRepositories.getKeys(tableName);
        if (null == definitionList) {
            throw new RepositoryException("Null definition list for table [" + tableName + "]");
        }
        HashMap<String, FieldDefinition> dMap = new HashMap<String, FieldDefinition>();
        for (FieldDefinition fieldDefinition : definitionList) {
            if (Latkes.RuntimeDatabase.H2 == Latkes.getRuntimeDatabase()) {
                dMap.put(fieldDefinition.getName().toUpperCase(), fieldDefinition);
                continue;
            }
            dMap.put(fieldDefinition.getName(), fieldDefinition);
        }
        int numColumns = resultSetMetaData.getColumnCount();
        ArrayList<JSONObject> list = new ArrayList<JSONObject>();
        while (resultSet.next()) {
            ret = new JSONObject();
            for (int i = 1; i < numColumns + 1; ++i) {
                String columnName = resultSetMetaData.getColumnLabel(i);
                FieldDefinition definition = (FieldDefinition)dMap.get(columnName);
                if (null == definition) {
                    ret.put(columnName, resultSet.getObject(columnName));
                    continue;
                }
                if ("boolean".equals(definition.getType())) {
                    ret.put(definition.getName(), resultSet.getBoolean(columnName));
                    continue;
                }
                Object v = resultSet.getObject(columnName);
                if (v instanceof Clob) {
                    Clob clob = (Clob)v;
                    String str = null;
                    try {
                        str = IOUtils.toString((Reader)clob.getCharacterStream());
                    }
                    catch (IOException e) {
                        LOGGER.log(Level.ERROR, "Cant not read column[name=" + columnName + "] in table[name=" + tableName + "] on H2", (Throwable)e);
                    }
                    finally {
                        try {
                            clob.free();
                        }
                        catch (Exception e) {
                            LOGGER.log(Level.ERROR, "clob.free error", (Throwable)e);
                        }
                    }
                    ret.put(definition.getName(), str);
                    continue;
                }
                ret.put(definition.getName(), v);
            }
            list.add(ret);
        }
        if (ifOnlyOne) {
            if (list.isEmpty()) {
                return null;
            }
            return (JSONObject)list.get(0);
        }
        ret = new JSONObject();
        ret.put("rslts", list);
        return ret;
    }

    private JdbcUtil() {
    }
}

