/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.latke.repository.jdbc.util;

import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.b3log.latke.repository.Repositories;
import org.b3log.latke.repository.jdbc.JdbcFactory;
import org.b3log.latke.repository.jdbc.util.Connections;
import org.b3log.latke.repository.jdbc.util.FieldDefinition;
import org.b3log.latke.repository.jdbc.util.RepositoryDefinition;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class JdbcRepositories {
    private static final Logger LOGGER = LogManager.getLogger(JdbcRepositories.class);
    private static final String REPOSITORIES = "repositories";
    private static final String DESCRIPTION = "description";
    private static final String NAME = "name";
    private static final String CHARSET = "charset";
    private static final String COLLATE = "collate";
    private static final String KEYS = "keys";
    private static final String TYPE = "type";
    private static final String NULLABLE = "nullable";
    private static final String LENGTH = "length";
    private static final String ISKEY = "iskey";
    public static String keyName = "oId";
    public static String softDeleteFieldName = "oDeleted";
    private static List<RepositoryDefinition> repositoryDefinitions = null;

    public static List<FieldDefinition> getKeys(String repositoryName) {
        List<RepositoryDefinition> repositoryDefs = JdbcRepositories.getRepositoryDefinitions();
        for (RepositoryDefinition repositoryDefinition : repositoryDefs) {
            if (!StringUtils.equals((CharSequence)repositoryName, (CharSequence)repositoryDefinition.getName())) continue;
            return repositoryDefinition.getKeys();
        }
        return null;
    }

    public static List<RepositoryDefinition> getRepositoryDefinitions() {
        if (null == repositoryDefinitions) {
            try {
                JdbcRepositories.initRepositoryDefinitions();
            }
            catch (Exception e) {
                LOGGER.log(Level.ERROR, "Init repository definitions failed", (Throwable)e);
            }
        }
        return repositoryDefinitions;
    }

    private static void initRepositoryDefinitions() throws JSONException {
        JSONObject jsonObject = Repositories.getRepositoriesDescription();
        if (null == jsonObject) {
            LOGGER.warn("Loads repository description [repository.json] failed");
            return;
        }
        repositoryDefinitions = new ArrayList<RepositoryDefinition>();
        JSONArray repositoritArray = jsonObject.getJSONArray(REPOSITORIES);
        for (int i = 0; i < repositoritArray.length(); ++i) {
            JSONObject repositoryObject = repositoritArray.getJSONObject(i);
            RepositoryDefinition repositoryDefinition = new RepositoryDefinition();
            repositoryDefinitions.add(repositoryDefinition);
            repositoryDefinition.setName(repositoryObject.getString(NAME));
            repositoryDefinition.setDescription(repositoryObject.optString(DESCRIPTION));
            ArrayList<FieldDefinition> keys = new ArrayList<FieldDefinition>();
            repositoryDefinition.setKeys(keys);
            JSONArray keysJsonArray = repositoryObject.getJSONArray(KEYS);
            for (int j = 0; j < keysJsonArray.length(); ++j) {
                JSONObject keyObject = keysJsonArray.getJSONObject(j);
                FieldDefinition definition = JdbcRepositories.fillFieldDefinitionData(keyObject);
                keys.add(definition);
            }
            repositoryDefinition.setCharset(repositoryObject.optString(CHARSET));
            repositoryDefinition.setCollate(repositoryObject.optString(COLLATE));
        }
    }

    private static FieldDefinition fillFieldDefinitionData(JSONObject fieldDefinitionObject) throws JSONException {
        FieldDefinition ret = new FieldDefinition();
        ret.setName(fieldDefinitionObject.getString(NAME));
        ret.setDescription(fieldDefinitionObject.optString(DESCRIPTION));
        ret.setType(fieldDefinitionObject.getString(TYPE));
        ret.setNullable(fieldDefinitionObject.optBoolean(NULLABLE));
        ret.setLength(fieldDefinitionObject.optInt(LENGTH));
        ret.setIsKey(fieldDefinitionObject.optBoolean(ISKEY));
        ret.setIsKey(keyName.equals(ret.getName()));
        return ret;
    }

    public static boolean existTable(String tableName) {
        return JdbcFactory.getInstance().existTable(tableName);
    }

    public static List<CreateTableResult> initAllTables() {
        ArrayList<CreateTableResult> ret = new ArrayList<CreateTableResult>();
        List<RepositoryDefinition> repositoryDefs = JdbcRepositories.getRepositoryDefinitions();
        boolean isSuccess = false;
        for (RepositoryDefinition repositoryDef : repositoryDefs) {
            try {
                isSuccess = JdbcFactory.getInstance().createTable(repositoryDef);
            }
            catch (SQLException e) {
                LOGGER.log(Level.ERROR, "Creates table [" + repositoryDef.getName() + "] error", (Throwable)e);
            }
            ret.add(new CreateTableResult(repositoryDef.getName(), isSuccess));
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initRepositoryJSON(String tablePrefix, Set<String> tableNames, String destPath) {
        FileWriter writer = null;
        try {
            File file = new File(destPath);
            if (file.isDirectory()) {
                LOGGER.log(Level.ERROR, "Can't generate repository definition file caused by the specified destination path [" + destPath + "] is a dir");
                return;
            }
            Connection connection = Connections.getConnection();
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            ResultSet resultSet = databaseMetaData.getTables(null, "%", "%", new String[]{"TABLE"});
            JSONObject repositoryJSON = new JSONObject();
            JSONArray repositories = new JSONArray();
            repositoryJSON.put(REPOSITORIES, repositories);
            while (resultSet.next()) {
                String fullTableName = resultSet.getString("TABLE_NAME");
                String tableName = StringUtils.substringAfter((String)fullTableName, (String)tablePrefix);
                if (!tableNames.contains(tableName)) continue;
                JSONObject repository = new JSONObject();
                repositories.put(repository);
                repository.put(NAME, tableName);
                String remarks = resultSet.getString("REMARKS");
                if (StringUtils.isNotBlank((CharSequence)remarks)) {
                    repository.put(DESCRIPTION, remarks);
                }
                JSONArray keys = new JSONArray();
                repository.put(KEYS, keys);
                ResultSet rs = databaseMetaData.getColumns(null, "%", fullTableName, "%");
                while (rs.next()) {
                    String columnName = rs.getString("COLUMN_NAME");
                    remarks = rs.getString("REMARKS");
                    int dataType = rs.getInt("DATA_TYPE");
                    int length = rs.getInt("COLUMN_SIZE");
                    int nullable = rs.getInt("NULLABLE");
                    JSONObject key = new JSONObject();
                    keys.put(key);
                    key.put(NAME, columnName);
                    if (StringUtils.isNotBlank((CharSequence)remarks)) {
                        key.put(DESCRIPTION, remarks);
                    }
                    if (0 != nullable) {
                        key.put(NULLABLE, true);
                    }
                    switch (dataType) {
                        case -16: 
                        case -15: 
                        case -9: 
                        case -1: 
                        case 1: 
                        case 12: {
                            key.put(TYPE, "String");
                            break;
                        }
                        case -5: {
                            key.put(TYPE, "long");
                            break;
                        }
                        case -6: 
                        case 4: 
                        case 5: {
                            key.put(TYPE, "int");
                            break;
                        }
                        case 91: {
                            key.put(TYPE, "Date");
                            break;
                        }
                        case 92: 
                        case 93: {
                            key.put(TYPE, "Datetime");
                            break;
                        }
                        case 2: 
                        case 3: {
                            key.put(TYPE, "Decimal");
                            key.put("precision", rs.getInt("DECIMAL_DIGITS"));
                            break;
                        }
                        case -7: {
                            key.put(TYPE, "Bit");
                            break;
                        }
                        case 2005: {
                            key.put(TYPE, "Clob");
                            break;
                        }
                        case 2004: {
                            key.put(TYPE, "Blob");
                            break;
                        }
                        case 8: {
                            key.put(TYPE, "double");
                            break;
                        }
                        default: {
                            throw new IllegalStateException("Unsupported type [" + dataType + "]");
                        }
                    }
                    key.put(LENGTH, length);
                }
            }
            FileUtils.deleteQuietly((File)file);
            writer = new FileWriter(file);
            String content = repositoryJSON.toString(Integer.valueOf("2"));
            IOUtils.write((String)content, (Writer)writer);
            LOGGER.log(Level.INFO, "Generated repository definition file [" + destPath + "]");
            IOUtils.closeQuietly((Writer)writer);
        }
        catch (Exception e) {
            LOGGER.log(Level.ERROR, "Init repository.json failed", (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly(writer);
        }
    }

    public static void setRepositoryDefinitions(List<RepositoryDefinition> repositoryDefinitions) {
        JdbcRepositories.repositoryDefinitions = repositoryDefinitions;
    }

    private JdbcRepositories() {
    }

    public static class CreateTableResult {
        private String name;
        private boolean isSuccess;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public boolean isSuccess() {
            return this.isSuccess;
        }

        public void setSuccess(boolean isSuccess) {
            this.isSuccess = isSuccess;
        }

        public CreateTableResult(String name, boolean isSuccess) {
            this.name = name;
            this.isSuccess = isSuccess;
        }
    }
}

