/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.latke.repository.jdbc;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.b3log.latke.repository.Repositories;
import org.b3log.latke.repository.jdbc.JdbcDatabase;
import org.b3log.latke.repository.jdbc.mapping.Mapping;
import org.b3log.latke.repository.jdbc.util.Connections;
import org.b3log.latke.repository.jdbc.util.JdbcRepositories;
import org.b3log.latke.repository.jdbc.util.JdbcUtil;
import org.b3log.latke.repository.jdbc.util.RepositoryDefinition;

public abstract class AbstractJdbcDatabaseSolution
implements JdbcDatabase {
    private final Map<String, Mapping> jdbcTypeMapping = new HashMap<String, Mapping>();

    public void registerType(String type, Mapping mapping) {
        this.jdbcTypeMapping.put(type, mapping);
    }

    @Override
    public boolean createTable(RepositoryDefinition repositoryDefinition) throws SQLException {
        try (Connection connection = Connections.getConnection();){
            StringBuilder createTableSqlBuilder = new StringBuilder();
            this.createTableHead(createTableSqlBuilder, repositoryDefinition);
            this.createTableBody(createTableSqlBuilder, repositoryDefinition);
            this.createTableEnd(createTableSqlBuilder, repositoryDefinition);
            boolean bl = JdbcUtil.executeSql(createTableSqlBuilder.toString(), connection, false);
            return bl;
        }
    }

    protected abstract void createTableHead(StringBuilder var1, RepositoryDefinition var2);

    protected abstract void createTableBody(StringBuilder var1, RepositoryDefinition var2);

    protected abstract void createTableEnd(StringBuilder var1, RepositoryDefinition var2);

    protected void createSoftDeleteField(StringBuilder createTableSqlBuilder) {
        if (!Repositories.isSoftDelete()) {
            return;
        }
        createTableSqlBuilder.append(JdbcRepositories.softDeleteFieldName).append(" INT NOT NULL, ");
    }

    public Map<String, Mapping> getJdbcTypeMapping() {
        return this.jdbcTypeMapping;
    }
}

