/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.latke.repository;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.b3log.latke.Latkes;
import org.b3log.latke.repository.AbstractRepository;
import org.b3log.latke.repository.Repository;
import org.b3log.latke.repository.RepositoryException;
import org.b3log.latke.util.CollectionUtils;
import org.b3log.latke.util.Strings;
import org.json.JSONArray;
import org.json.JSONObject;

public final class Repositories {
    private static final Logger LOGGER = LogManager.getLogger(Repositories.class);
    private static final Map<String, Repository> REPOS_HOLDER = new ConcurrentHashMap<String, Repository>();
    private static JSONObject repositoriesDescription;
    private static boolean repositoriesWritable;
    private static boolean softDelete;

    public static boolean isSoftDelete() {
        return softDelete;
    }

    public static void setSoftDelete(boolean softDelete) {
        Repositories.softDelete = softDelete;
    }

    public static boolean getRepositoriesWritable() {
        return repositoriesWritable;
    }

    public static void setRepositoriesWritable(boolean writable) {
        for (Map.Entry<String, Repository> entry : REPOS_HOLDER.entrySet()) {
            String repositoryName = entry.getKey();
            Repository repository = entry.getValue();
            repository.setWritable(writable);
            LOGGER.log(Level.INFO, "Sets repository[name={}] writable[{}]", (Object)repositoryName, (Object)writable);
        }
        repositoriesWritable = writable;
    }

    public static JSONArray getRepositoryNames() {
        JSONArray ret = new JSONArray();
        if (null == repositoriesDescription) {
            LOGGER.log(Level.INFO, "Not found repository description[repository.json] file under classpath");
            return ret;
        }
        JSONArray repositories = repositoriesDescription.optJSONArray("repositories");
        for (int i = 0; i < repositories.length(); ++i) {
            JSONObject repository = repositories.optJSONObject(i);
            ret.put(repository.optString("name"));
        }
        return ret;
    }

    public static JSONObject getRepositoriesDescription() {
        return repositoriesDescription;
    }

    public static void check(String repositoryName, JSONObject jsonObject, String ... ignoredKeys) throws RepositoryException {
        int i;
        if (null == jsonObject) {
            throw new RepositoryException("Null to persist to repository [" + repositoryName + "]");
        }
        JSONObject repositoryDef = Repositories.getRepositoryDef(repositoryName);
        if (!repositoryDef.optBoolean("fieldcheck")) {
            return;
        }
        boolean needIgnoreKeys = null != ignoredKeys && 0 < ignoredKeys.length;
        JSONArray names = jsonObject.names();
        Set nameSet = CollectionUtils.jsonArrayToSet(names);
        JSONArray keysDef = repositoryDef.optJSONArray("keys");
        if (null == keysDef) {
            return;
        }
        HashSet<String> keySet = new HashSet<String>();
        for (i = 0; i < keysDef.length(); ++i) {
            JSONObject keyDescription = keysDef.optJSONObject(i);
            String key = keyDescription.optString("name");
            keySet.add(key);
            if (needIgnoreKeys && Strings.containsIgnoreCase(key, ignoredKeys) || keyDescription.optBoolean("nullable") || nameSet.contains(key)) continue;
            throw new RepositoryException("A json object to persist to repository [name=" + repositoryName + "] does not contain a key [" + key + "]");
        }
        for (i = 0; i < names.length(); ++i) {
            String name = names.optString(i);
            if (keySet.contains(name)) continue;
            throw new RepositoryException("A json object to persist to repository [name=" + repositoryName + "] contains an redundant key [" + name + "]");
        }
    }

    public static JSONObject getRepositoryDef(String repositoryName) {
        if (StringUtils.isBlank((CharSequence)repositoryName)) {
            return null;
        }
        if (null == repositoriesDescription) {
            return null;
        }
        JSONArray repositories = repositoriesDescription.optJSONArray("repositories");
        for (int i = 0; i < repositories.length(); ++i) {
            JSONObject repository = repositories.optJSONObject(i);
            if (!repositoryName.equals(repository.optString("name"))) continue;
            return repository;
        }
        throw new RuntimeException("Not found the repository [name=" + repositoryName + "] definition, please define it in repositories.json");
    }

    public static JSONArray getRepositoryKeysDef(String repositoryName) {
        if (StringUtils.isBlank((CharSequence)repositoryName)) {
            return null;
        }
        if (null == repositoriesDescription) {
            return null;
        }
        JSONArray repositories = repositoriesDescription.optJSONArray("repositories");
        for (int i = 0; i < repositories.length(); ++i) {
            JSONObject repository = repositories.optJSONObject(i);
            if (!repositoryName.equals(repository.optString("name"))) continue;
            return repository.optJSONArray("keys");
        }
        throw new RuntimeException("Not found the repository [name=" + repositoryName + "] definition, please define it in repositories.json");
    }

    public static Repository getRepository(String repositoryName) {
        return REPOS_HOLDER.get(repositoryName);
    }

    public static void addRepository(Repository repository) {
        REPOS_HOLDER.put(repository.getName(), repository);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadRepositoryDescription() {
        LOGGER.log(Level.DEBUG, "Loading repository description....");
        InputStream inputStream = AbstractRepository.class.getResourceAsStream("/repository.json");
        if (null == inputStream) {
            LOGGER.log(Level.INFO, "Not found repository description [repository.json] file under classpath");
            return;
        }
        LOGGER.log(Level.DEBUG, "Parsing repository description....");
        try {
            String description = IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
            LOGGER.log(Level.DEBUG, "{}{}", new Object[]{Strings.LINE_SEPARATOR, description});
            repositoriesDescription = new JSONObject(description);
            String tableNamePrefix = StringUtils.isNotBlank((CharSequence)Latkes.getLocalProperty("jdbc.tablePrefix")) ? Latkes.getLocalProperty("jdbc.tablePrefix") + "_" : "";
            JSONArray repositories = repositoriesDescription.optJSONArray("repositories");
            for (int i = 0; i < repositories.length(); ++i) {
                JSONObject repository = repositories.optJSONObject(i);
                repository.put("name", tableNamePrefix + repository.optString("name"));
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.ERROR, "Parses repository description failed", (Throwable)e);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException e) {
                LOGGER.log(Level.ERROR, e.getMessage(), (Throwable)e);
                throw new RuntimeException(e);
            }
        }
    }

    private Repositories() {
    }

    static {
        repositoriesWritable = true;
        softDelete = false;
        Repositories.loadRepositoryDescription();
    }
}

