/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.latke.ioc;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.concurrent.atomic.AtomicInteger;
import javassist.util.proxy.MethodFilter;
import javassist.util.proxy.MethodHandler;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.b3log.latke.ioc.BeanManager;
import org.b3log.latke.repository.annotation.Transactional;
import org.b3log.latke.repository.jdbc.JdbcRepository;
import org.b3log.latke.repository.jdbc.JdbcTransaction;

final class JavassistMethodHandler
implements MethodHandler {
    private static final Logger LOGGER = LogManager.getLogger(JavassistMethodHandler.class);
    private final BeanManager beanManager;
    private static final ThreadLocal<AtomicInteger> CALLS = new ThreadLocal();
    private final MethodFilter methodFilter = method -> {
        String pkg = method.getDeclaringClass().getPackage().getName();
        if (StringUtils.startsWithAny((CharSequence)pkg, (CharSequence[])new String[]{"org.b3log.latke", "java.", "javax."})) {
            return false;
        }
        String name = method.getName();
        return !"invoke".equals(name) && !"beginTransaction".equals(name) && !"hasTransactionBegun".equals(name);
    };

    JavassistMethodHandler(BeanManager beanManager) {
        this.beanManager = beanManager;
    }

    public Object invoke(Object proxy, Method method, Method proceed, Object[] params) throws Throwable {
        Object ret;
        boolean needHandleTrans;
        LOGGER.trace("Processing invocation [" + method.toString() + "]");
        AtomicInteger calls = CALLS.get();
        if (null == calls) {
            calls = new AtomicInteger(0);
            CALLS.set(calls);
        }
        calls.incrementAndGet();
        boolean withTransactionalAnno = method.isAnnotationPresent(Transactional.class);
        JdbcTransaction transaction = JdbcRepository.TX.get();
        boolean alreadyInTransaction = null != transaction;
        boolean bl = needHandleTrans = withTransactionalAnno && !alreadyInTransaction;
        if (needHandleTrans) {
            try {
                transaction = new JdbcTransaction();
            }
            catch (SQLException e) {
                LOGGER.log(Level.ERROR, "Failed to initialize JDBC transaction", (Throwable)e);
                throw new IllegalStateException("Begin a transaction failed");
            }
            JdbcRepository.TX.set(transaction);
        }
        try {
            ret = proceed.invoke(proxy, params);
            if (needHandleTrans) {
                transaction.commit();
            }
        }
        catch (InvocationTargetException e) {
            transaction = JdbcRepository.TX.get();
            if (null != transaction && transaction.isActive()) {
                transaction.rollback();
            }
            throw e.getTargetException();
        }
        finally {
            if (0 == calls.decrementAndGet()) {
                CALLS.remove();
                Connection connection = JdbcRepository.CONN.get();
                if (null != connection) {
                    connection.close();
                    JdbcRepository.CONN.remove();
                }
            }
        }
        return ret;
    }

    public MethodFilter getMethodFilter() {
        return this.methodFilter;
    }
}

