/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.latke.ioc;

import java.io.DataInputStream;
import java.net.URL;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import javassist.bytecode.AnnotationsAttribute;
import javassist.bytecode.AttributeInfo;
import javassist.bytecode.ClassFile;
import javassist.bytecode.ConstPool;
import javassist.bytecode.annotation.Annotation;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.b3log.latke.ioc.ClassPathResolver;
import org.b3log.latke.ioc.Singleton;
import org.b3log.latke.repository.annotation.Repository;
import org.b3log.latke.service.annotation.Service;
import org.b3log.latke.util.ArrayUtils;

public final class Discoverer {
    private static final Logger LOGGER = LogManager.getLogger(Discoverer.class);
    private static final String[] BUILT_IN_COMPONENT_PKGS = new String[]{"org.b3log.latke.remote"};

    private Discoverer() {
    }

    public static Collection<Class<?>> discover(String scanPath) {
        if (StringUtils.isBlank((CharSequence)scanPath)) {
            throw new IllegalStateException("Please specify the [scanPath]");
        }
        LOGGER.debug("scanPath[" + scanPath + "]");
        HashSet ret = new HashSet();
        String[] splitPaths = scanPath.split(",");
        String[] paths = ArrayUtils.concatenate(splitPaths, new String[][]{BUILT_IN_COMPONENT_PKGS});
        LinkedHashSet<URL> urls = new LinkedHashSet<URL>();
        for (String string : paths) {
            String string2 = string.replaceAll("\\.", "/") + "/**/*.class";
            urls.addAll(ClassPathResolver.getResources(string2));
        }
        try {
            for (URL url : urls) {
                DataInputStream classInputStream = new DataInputStream(url.openStream());
                ClassFile classFile = new ClassFile(classInputStream);
                String className = classFile.getName();
                AnnotationsAttribute annotationsAttribute = (AnnotationsAttribute)classFile.getAttribute("RuntimeVisibleAnnotations");
                if (null == annotationsAttribute) {
                    LOGGER.log(Level.TRACE, "The class [name={}] is not a bean", (Object)className);
                    continue;
                }
                ConstPool constPool = classFile.getConstPool();
                Annotation[] annotations = annotationsAttribute.getAnnotations();
                boolean maybeBeanClass = false;
                for (Annotation annotation : annotations) {
                    String typeName = annotation.getTypeName();
                    if (typeName.equals(Singleton.class.getName())) {
                        maybeBeanClass = true;
                        break;
                    }
                    if (!typeName.equals(Service.class.getName()) && !typeName.equals(Repository.class.getName())) continue;
                    Annotation singletonAnnotation = new Annotation(Singleton.class.getName(), constPool);
                    annotationsAttribute.addAnnotation(singletonAnnotation);
                    classFile.addAttribute((AttributeInfo)annotationsAttribute);
                    classFile.setVersionToJava5();
                    maybeBeanClass = true;
                    break;
                }
                if (!maybeBeanClass) continue;
                Class<?> clz = null;
                try {
                    clz = Thread.currentThread().getContextClassLoader().loadClass(className);
                }
                catch (ClassNotFoundException e) {
                    LOGGER.log(Level.ERROR, "Loads class [" + className + "] failed", (Throwable)e);
                }
                ret.add(clz);
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.ERROR, "Load classes failed", (Throwable)e);
        }
        return ret;
    }
}

