/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.latke.ioc;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.b3log.latke.ioc.Bean;
import org.b3log.latke.ioc.BeanManager;
import org.b3log.latke.util.Reflections;

public class Configurator {
    private static final Logger LOGGER = LogManager.getLogger(Configurator.class);
    private final BeanManager beanManager;
    private final Map<Type, Set<Class<?>>> typeClasses;

    public Configurator(BeanManager beanManager) {
        this.beanManager = beanManager;
        this.typeClasses = new HashMap();
    }

    public void addTypeClassBinding(Type beanType, Class<?> beanClass) {
        Set<Class<?>> beanClasses = this.typeClasses.get(beanType);
        if (null == beanClasses) {
            beanClasses = new HashSet();
        }
        beanClasses.add(beanClass);
        this.typeClasses.put(beanType, beanClasses);
    }

    public <T> Bean<T> createBean(Class<T> beanClass) {
        try {
            return this.beanManager.getBean(beanClass);
        }
        catch (Exception e) {
            LOGGER.log(Level.TRACE, "Not found bean [beanClass={}], so to create it", beanClass);
            if (Reflections.isAbstract(beanClass) || Reflections.isInterface(beanClass)) {
                throw new IllegalStateException("Can't create bean for class [" + beanClass.getName() + "] caused by it is an interface or an abstract class, or it dose not implement any interface");
            }
            String className = beanClass.getName();
            String name = className.substring(0, 1).toLowerCase() + className.substring(1);
            Set<Type> beanTypes = Reflections.getBeanTypes(beanClass);
            Set<Class<? extends Annotation>> stereotypes = Reflections.getStereotypes(beanClass);
            LOGGER.log(Level.DEBUG, "Adding a bean [name={}, class={}] to the bean manager", (Object)name, (Object)beanClass.getName());
            Bean<T> ret = new Bean<T>(this.beanManager, name, beanClass, beanTypes, stereotypes);
            this.beanManager.addBean(ret);
            for (Type beanType : beanTypes) {
                this.addTypeClassBinding(beanType, beanClass);
            }
            return ret;
        }
    }

    public void createBeans(Collection<Class<?>> classes) {
        if (null == classes || classes.isEmpty()) {
            return;
        }
        Configurator.filterClasses(classes);
        for (Class<?> clazz : classes) {
            this.createBean(clazz);
        }
    }

    private static void filterClasses(Collection<Class<?>> classes) {
        classes.removeIf(clazz -> clazz.isAnnotation() || !Reflections.isConcrete(clazz));
    }
}

