/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.latke.ioc;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.b3log.latke.event.EventManager;
import org.b3log.latke.ioc.Bean;
import org.b3log.latke.ioc.Configurator;
import org.b3log.latke.ioc.InjectionPoint;
import org.b3log.latke.ioc.Singleton;
import org.b3log.latke.ioc.SingletonContext;
import org.b3log.latke.plugin.PluginManager;
import org.b3log.latke.service.LangPropsService;

@Singleton
public class BeanManager {
    private static final Logger LOGGER = LogManager.getLogger(BeanManager.class);
    private static Set<Bean<?>> builtInBeans;
    private static final List<Class<?>> builtInBeanClasses;
    private final Configurator configurator;
    private final Set<Bean<?>> beans;
    private final SingletonContext context;

    private BeanManager() {
        LOGGER.log(Level.DEBUG, "Creating bean manager");
        this.beans = new HashSet();
        this.context = new SingletonContext();
        builtInBeans = new HashSet();
        this.configurator = new Configurator(this);
        this.configurator.createBean(BeanManager.class);
        for (Class<?> builtInBeanClass : builtInBeanClasses) {
            Bean<?> builtInBean = this.configurator.createBean(builtInBeanClass);
            builtInBeans.add(builtInBean);
            this.context.get(builtInBean);
        }
        this.beans.addAll(builtInBeans);
        LOGGER.log(Level.DEBUG, "Created Latke bean manager");
    }

    public static void start(Collection<Class<?>> classes) {
        LOGGER.log(Level.DEBUG, "Initializing Latke IoC container");
        Configurator configurator = BeanManager.getInstance().getConfigurator();
        if (null != classes && !classes.isEmpty()) {
            configurator.createBeans(classes);
        }
        LOGGER.log(Level.DEBUG, "Initialized Latke IoC container");
    }

    public static void close() {
        LOGGER.log(Level.DEBUG, "Closed Latke IoC container");
    }

    public static BeanManager getInstance() {
        return BeanManagerHolder.instance;
    }

    public void addBean(Bean<?> bean) {
        this.beans.add(bean);
    }

    public Set<Bean<?>> getBeans(Class<? extends Annotation> stereoType) {
        HashSet ret = new HashSet();
        for (Bean<?> bean : this.beans) {
            Set<Class<Annotation>> stereotypes = bean.getStereotypes();
            if (!stereotypes.contains(stereoType)) continue;
            ret.add(bean);
        }
        return ret;
    }

    public Configurator getConfigurator() {
        return this.configurator;
    }

    public <T> T getReference(Bean<T> bean) {
        return this.context.get(bean);
    }

    public Object getInjectableReference(InjectionPoint ij) {
        Type baseType = ij.getAnnotated().getBaseType();
        Bean bean = this.getBean(baseType);
        return this.getReference(bean);
    }

    public <T> Bean<T> getBean(Class<T> beanClass) {
        for (Bean<?> bean : this.beans) {
            if (!bean.getBeanClass().equals(beanClass)) continue;
            return bean;
        }
        throw new RuntimeException("Not found bean [beanClass=" + beanClass.getName() + "]");
    }

    private <T> Bean<T> getBean(Type beanType) {
        for (Bean<?> bean : this.beans) {
            if (!bean.getTypes().contains(beanType)) continue;
            return bean;
        }
        throw new RuntimeException("Not found bean [beanType=" + beanType + "]");
    }

    public <T> T getReference(Class<T> beanClass) {
        Bean<T> bean = this.getBean(beanClass);
        return this.getReference(bean);
    }

    static {
        builtInBeanClasses = Arrays.asList(LangPropsService.class, EventManager.class, PluginManager.class);
    }

    private static final class BeanManagerHolder {
        private static final BeanManager instance = new BeanManager();

        private BeanManagerHolder() {
        }
    }
}

