/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.latke.http.renderer;

import freemarker.template.Template;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.b3log.latke.Keys;
import org.b3log.latke.http.Request;
import org.b3log.latke.http.RequestContext;
import org.b3log.latke.http.Response;
import org.b3log.latke.http.renderer.AbstractResponseRenderer;
import org.b3log.latke.util.Requests;

public abstract class AbstractFreeMarkerRenderer
extends AbstractResponseRenderer {
    private static final Logger LOGGER = LogManager.getLogger(AbstractFreeMarkerRenderer.class);
    private String templateName;
    private final Map<String, Object> dataModel = new HashMap<String, Object>();

    protected abstract void beforeRender(RequestContext var1) throws Exception;

    protected abstract void afterRender(RequestContext var1) throws Exception;

    protected abstract Template getTemplate();

    @Override
    public void render(RequestContext context) {
        Response response = context.getResponse();
        response.setContentType("text/html; charset=utf-8");
        if (response.isCommitted()) {
            return;
        }
        Request request = context.getRequest();
        Template template = this.getTemplate();
        if (null == template) {
            LOGGER.log(Level.ERROR, "Not found template [{}]", (Object)this.templateName);
            response.sendError0(404);
            return;
        }
        try {
            this.dataModel.put("request", request);
            Keys.fillServer(this.dataModel);
            this.beforeRender(context);
            String html = this.genHTML(context.getRequest(), this.dataModel, template);
            this.doRender(html, context.getRequest(), response);
            this.afterRender(context);
        }
        catch (Exception e) {
            String requestLog = Requests.getLog(request);
            LOGGER.log(Level.ERROR, "Renders template [" + this.templateName + "] failed [" + requestLog + "]", (Throwable)e);
            if (null != context.attr("ERROR_CODE")) {
                response.sendError0(500);
            }
            response.sendError(500);
        }
    }

    protected String genHTML(Request request, Map<String, Object> dataModel, Template template) throws Exception {
        StringWriter stringWriter = new StringWriter();
        template.setOutputEncoding("UTF-8");
        template.process(dataModel, (Writer)stringWriter);
        StringBuilder pageContentBuilder = new StringBuilder(stringWriter.toString());
        long endTimeMillis = System.currentTimeMillis();
        String dateString = DateFormatUtils.format((long)endTimeMillis, (String)"yyyy/MM/dd HH:mm:ss");
        long startTimeMillis = (Long)request.getAttribute("startTimeMillis");
        String msg = String.format("\n<!-- Generated by Latke (https://github.com/88250/latke) in %1$dms, %2$s -->", endTimeMillis - startTimeMillis, dateString);
        pageContentBuilder.append(msg);
        return pageContentBuilder.toString();
    }

    protected void doRender(String html, Request request, Response response) {
        if (response.isCommitted()) {
            return;
        }
        response.sendString(html);
    }

    public Map<String, Object> getDataModel() {
        return this.dataModel;
    }

    public String getTemplateName() {
        return this.templateName;
    }

    public void setTemplateName(String templateName) {
        this.templateName = templateName;
    }

    @Override
    public Map<String, Object> getRenderDataModel() {
        return this.dataModel;
    }
}

