/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.latke.http.handler;

import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.b3log.latke.Latkes;
import org.b3log.latke.http.HttpMethod;
import org.b3log.latke.http.Request;
import org.b3log.latke.http.RequestContext;
import org.b3log.latke.http.function.Handler;
import org.b3log.latke.http.handler.ContextHandlerMeta;
import org.b3log.latke.http.handler.RouteResolution;
import org.b3log.latke.util.UriTemplates;

public class RouteHandler
implements Handler {
    private static final Logger LOGGER = LogManager.getLogger(RouteHandler.class);
    private static final Map<String, ContextHandlerMeta> ONE_SEG_CONCRETE_CTX_HANDLER_METAS = new ConcurrentHashMap<String, ContextHandlerMeta>();
    private static final Map<String, ContextHandlerMeta> ONE_SEG_GET_VAR_CTX_HANDLER_METAS = new ConcurrentHashMap<String, ContextHandlerMeta>();
    private static final Map<String, ContextHandlerMeta> ONE_SEG_POST_VAR_CTX_HANDLER_METAS = new ConcurrentHashMap<String, ContextHandlerMeta>();
    private static final Map<String, ContextHandlerMeta> ONE_SEG_PUT_VAR_CTX_HANDLER_METAS = new ConcurrentHashMap<String, ContextHandlerMeta>();
    private static final Map<String, ContextHandlerMeta> ONE_SEG_DELETE_VAR_CTX_HANDLER_METAS = new ConcurrentHashMap<String, ContextHandlerMeta>();
    private static final Map<String, ContextHandlerMeta> ONE_SEG_OTHER_METHOD_VAR_CTX_HANDLER_METAS = new ConcurrentHashMap<String, ContextHandlerMeta>();
    private static final Map<String, ContextHandlerMeta> TWO_SEG_CONCRETE_CTX_HANDLER_METAS = new ConcurrentHashMap<String, ContextHandlerMeta>();
    private static final Map<String, ContextHandlerMeta> TWO_SEG_GET_VAR_CTX_HANDLER_METAS = new ConcurrentHashMap<String, ContextHandlerMeta>();
    private static final Map<String, ContextHandlerMeta> TWO_SEG_POST_VAR_CTX_HANDLER_METAS = new ConcurrentHashMap<String, ContextHandlerMeta>();
    private static final Map<String, ContextHandlerMeta> TWO_SEG_PUT_VAR_CTX_HANDLER_METAS = new ConcurrentHashMap<String, ContextHandlerMeta>();
    private static final Map<String, ContextHandlerMeta> TWO_SEG_DELETE_VAR_CTX_HANDLER_METAS = new ConcurrentHashMap<String, ContextHandlerMeta>();
    private static final Map<String, ContextHandlerMeta> TWO_SEG_OTHER_METHOD_VAR_CTX_HANDLER_METAS = new ConcurrentHashMap<String, ContextHandlerMeta>();
    private static final Map<String, ContextHandlerMeta> THREE_SEG_CONCRETE_CTX_HANDLER_METAS = new ConcurrentHashMap<String, ContextHandlerMeta>();
    private static final Map<String, ContextHandlerMeta> THREE_SEG_GET_VAR_CTX_HANDLER_METAS = new ConcurrentHashMap<String, ContextHandlerMeta>();
    private static final Map<String, ContextHandlerMeta> THREE_SEG_POST_VAR_CTX_HANDLER_METAS = new ConcurrentHashMap<String, ContextHandlerMeta>();
    private static final Map<String, ContextHandlerMeta> THREE_SEG_PUT_VAR_CTX_HANDLER_METAS = new ConcurrentHashMap<String, ContextHandlerMeta>();
    private static final Map<String, ContextHandlerMeta> THREE_SEG_DELETE_VAR_CTX_HANDLER_METAS = new ConcurrentHashMap<String, ContextHandlerMeta>();
    private static final Map<String, ContextHandlerMeta> THREE_SEG_OTHER_METHOD_VAR_CTX_HANDLER_METAS = new ConcurrentHashMap<String, ContextHandlerMeta>();
    private static final Map<String, ContextHandlerMeta> FOUR_MORE_SEG_CONCRETE_CTX_HANDLER_METAS = new ConcurrentHashMap<String, ContextHandlerMeta>();
    private static final Map<String, ContextHandlerMeta> FOUR_MORE_SEG_GET_VAR_CTX_HANDLER_METAS = new ConcurrentHashMap<String, ContextHandlerMeta>();
    private static final Map<String, ContextHandlerMeta> FOUR_MORE_SEG_POST_VAR_CTX_HANDLER_METAS = new ConcurrentHashMap<String, ContextHandlerMeta>();
    private static final Map<String, ContextHandlerMeta> FOUR_MORE_SEG_PUT_VAR_CTX_HANDLER_METAS = new ConcurrentHashMap<String, ContextHandlerMeta>();
    private static final Map<String, ContextHandlerMeta> FOUR_MORE_SEG_DELETE_VAR_CTX_HANDLER_METAS = new ConcurrentHashMap<String, ContextHandlerMeta>();
    private static final Map<String, ContextHandlerMeta> FOUR_MORE_SEG_OTHER_METHOD_VAR_CTX_HANDLER_METAS = new ConcurrentHashMap<String, ContextHandlerMeta>();

    @Override
    public void handle(RequestContext context) {
        Request request = context.getRequest();
        long startTimeMillis = System.currentTimeMillis();
        request.setAttribute("startTimeMillis", startTimeMillis);
        String requestURI = this.getRequestURI(request);
        requestURI = StringUtils.substringAfter((String)requestURI, (String)Latkes.getContextPath());
        String httpMethod = this.getHttpMethod(request);
        LOGGER.log(Level.DEBUG, "Request [requestURI={}, method={}]", (Object)requestURI, (Object)httpMethod);
        RouteResolution result = RouteHandler.doMatch(requestURI, httpMethod);
        if (null == result) {
            context.abort();
            return;
        }
        ContextHandlerMeta contextHandlerMeta = result.getContextHandlerMeta();
        List<Handler> middlewares = contextHandlerMeta.getMiddlewares();
        for (int i = middlewares.size() - 1; 0 <= i; --i) {
            Handler middleware = middlewares.get(i);
            context.insertHandlerAfter(middleware);
        }
        context.pathVars(result.getPathVars());
        context.attr("MATCH_RESULT", result);
        context.handle();
    }

    public static RouteResolution doMatch(String requestURI, String httpMethod) {
        int segs = StringUtils.countMatches((CharSequence)requestURI, (CharSequence)"/");
        String concreteKey = httpMethod + "." + requestURI;
        switch (segs) {
            case 1: {
                ContextHandlerMeta contextHandlerMeta = ONE_SEG_CONCRETE_CTX_HANDLER_METAS.get(concreteKey);
                if (null != contextHandlerMeta) {
                    return new RouteResolution(contextHandlerMeta, requestURI, httpMethod);
                }
                switch (httpMethod) {
                    case "GET": {
                        return RouteHandler.route(requestURI, httpMethod, ONE_SEG_GET_VAR_CTX_HANDLER_METAS);
                    }
                    case "POST": {
                        return RouteHandler.route(requestURI, httpMethod, ONE_SEG_POST_VAR_CTX_HANDLER_METAS);
                    }
                    case "PUT": {
                        return RouteHandler.route(requestURI, httpMethod, ONE_SEG_PUT_VAR_CTX_HANDLER_METAS);
                    }
                    case "DELETE": {
                        return RouteHandler.route(requestURI, httpMethod, ONE_SEG_DELETE_VAR_CTX_HANDLER_METAS);
                    }
                }
                return RouteHandler.route(requestURI, httpMethod, ONE_SEG_OTHER_METHOD_VAR_CTX_HANDLER_METAS);
            }
            case 2: {
                ContextHandlerMeta contextHandlerMeta = TWO_SEG_CONCRETE_CTX_HANDLER_METAS.get(concreteKey);
                if (null != contextHandlerMeta) {
                    return new RouteResolution(contextHandlerMeta, requestURI, httpMethod);
                }
                switch (httpMethod) {
                    case "GET": {
                        return RouteHandler.route(requestURI, httpMethod, TWO_SEG_GET_VAR_CTX_HANDLER_METAS);
                    }
                    case "POST": {
                        return RouteHandler.route(requestURI, httpMethod, TWO_SEG_POST_VAR_CTX_HANDLER_METAS);
                    }
                    case "PUT": {
                        return RouteHandler.route(requestURI, httpMethod, TWO_SEG_PUT_VAR_CTX_HANDLER_METAS);
                    }
                    case "DELETE": {
                        return RouteHandler.route(requestURI, httpMethod, TWO_SEG_DELETE_VAR_CTX_HANDLER_METAS);
                    }
                }
                return RouteHandler.route(requestURI, httpMethod, TWO_SEG_OTHER_METHOD_VAR_CTX_HANDLER_METAS);
            }
            case 3: {
                ContextHandlerMeta contextHandlerMeta = THREE_SEG_CONCRETE_CTX_HANDLER_METAS.get(concreteKey);
                if (null != contextHandlerMeta) {
                    return new RouteResolution(contextHandlerMeta, requestURI, httpMethod);
                }
                switch (httpMethod) {
                    case "GET": {
                        return RouteHandler.route(requestURI, httpMethod, THREE_SEG_GET_VAR_CTX_HANDLER_METAS);
                    }
                    case "POST": {
                        return RouteHandler.route(requestURI, httpMethod, THREE_SEG_POST_VAR_CTX_HANDLER_METAS);
                    }
                    case "PUT": {
                        return RouteHandler.route(requestURI, httpMethod, THREE_SEG_PUT_VAR_CTX_HANDLER_METAS);
                    }
                    case "DELETE": {
                        return RouteHandler.route(requestURI, httpMethod, THREE_SEG_DELETE_VAR_CTX_HANDLER_METAS);
                    }
                }
                return RouteHandler.route(requestURI, httpMethod, THREE_SEG_OTHER_METHOD_VAR_CTX_HANDLER_METAS);
            }
        }
        ContextHandlerMeta contextHandlerMeta = FOUR_MORE_SEG_CONCRETE_CTX_HANDLER_METAS.get(concreteKey);
        if (null != contextHandlerMeta) {
            return new RouteResolution(contextHandlerMeta, requestURI, httpMethod);
        }
        switch (httpMethod) {
            case "GET": {
                return RouteHandler.route(requestURI, httpMethod, FOUR_MORE_SEG_GET_VAR_CTX_HANDLER_METAS);
            }
            case "POST": {
                return RouteHandler.route(requestURI, httpMethod, FOUR_MORE_SEG_POST_VAR_CTX_HANDLER_METAS);
            }
            case "PUT": {
                return RouteHandler.route(requestURI, httpMethod, FOUR_MORE_SEG_PUT_VAR_CTX_HANDLER_METAS);
            }
            case "DELETE": {
                return RouteHandler.route(requestURI, httpMethod, FOUR_MORE_SEG_DELETE_VAR_CTX_HANDLER_METAS);
            }
        }
        return RouteHandler.route(requestURI, httpMethod, FOUR_MORE_SEG_OTHER_METHOD_VAR_CTX_HANDLER_METAS);
    }

    public static void addContextHandlerMeta(ContextHandlerMeta contextHandlerMeta) {
        Class<?> parameterType;
        Class<?>[] parameterTypes;
        Class<?>[] exceptionTypes;
        Method invokeHolder = contextHandlerMeta.getInvokeHolder();
        Class<?> returnType = invokeHolder.getReturnType();
        String methodName = invokeHolder.getDeclaringClass().getName() + "#" + invokeHolder.getName();
        if (!Void.TYPE.equals(returnType)) {
            LOGGER.error("Handler method [" + methodName + "] must return void");
            System.exit(-1);
        }
        if (0 < (exceptionTypes = invokeHolder.getExceptionTypes()).length) {
            LOGGER.error("Handler method [" + methodName + "] can not throw exceptions");
            System.exit(-1);
        }
        if (1 != (parameterTypes = invokeHolder.getParameterTypes()).length) {
            LOGGER.error("Handler method [" + methodName + "] must have one parameter with type [RequestContext]");
            System.exit(-1);
        }
        if (!RequestContext.class.equals(parameterType = parameterTypes[0])) {
            LOGGER.error("Handler method [" + methodName + "] must have one parameter with type [RequestContext]");
            System.exit(-1);
        }
        HttpMethod[] httpMethods = contextHandlerMeta.getHttpMethods();
        for (int i = 0; i < httpMethods.length; ++i) {
            String httpMethod = httpMethods[i].name();
            String[] uriTemplates = contextHandlerMeta.getUriTemplates();
            block59: for (int j = 0; j < uriTemplates.length; ++j) {
                String uriTemplate = uriTemplates[j];
                String key = httpMethod + "." + uriTemplate;
                int segs = StringUtils.countMatches((CharSequence)uriTemplate, (CharSequence)"/");
                if (!StringUtils.contains((CharSequence)uriTemplate, (CharSequence)"{")) {
                    switch (segs) {
                        case 1: {
                            ONE_SEG_CONCRETE_CTX_HANDLER_METAS.put(key, contextHandlerMeta);
                            break;
                        }
                        case 2: {
                            TWO_SEG_CONCRETE_CTX_HANDLER_METAS.put(key, contextHandlerMeta);
                            break;
                        }
                        case 3: {
                            THREE_SEG_CONCRETE_CTX_HANDLER_METAS.put(key, contextHandlerMeta);
                            break;
                        }
                        default: {
                            FOUR_MORE_SEG_CONCRETE_CTX_HANDLER_METAS.put(key, contextHandlerMeta);
                            break;
                        }
                    }
                    continue;
                }
                switch (segs) {
                    case 1: {
                        switch (httpMethod) {
                            case "GET": {
                                ONE_SEG_GET_VAR_CTX_HANDLER_METAS.put(uriTemplate, contextHandlerMeta);
                                continue block59;
                            }
                            case "POST": {
                                ONE_SEG_POST_VAR_CTX_HANDLER_METAS.put(uriTemplate, contextHandlerMeta);
                                continue block59;
                            }
                            case "PUT": {
                                ONE_SEG_PUT_VAR_CTX_HANDLER_METAS.put(uriTemplate, contextHandlerMeta);
                                continue block59;
                            }
                            case "DELETE": {
                                ONE_SEG_DELETE_VAR_CTX_HANDLER_METAS.put(uriTemplate, contextHandlerMeta);
                                continue block59;
                            }
                        }
                        ONE_SEG_OTHER_METHOD_VAR_CTX_HANDLER_METAS.put(uriTemplate, contextHandlerMeta);
                        continue block59;
                    }
                    case 2: {
                        switch (httpMethod) {
                            case "GET": {
                                TWO_SEG_GET_VAR_CTX_HANDLER_METAS.put(uriTemplate, contextHandlerMeta);
                                continue block59;
                            }
                            case "POST": {
                                TWO_SEG_POST_VAR_CTX_HANDLER_METAS.put(uriTemplate, contextHandlerMeta);
                                continue block59;
                            }
                            case "PUT": {
                                TWO_SEG_PUT_VAR_CTX_HANDLER_METAS.put(uriTemplate, contextHandlerMeta);
                                continue block59;
                            }
                            case "DELETE": {
                                TWO_SEG_DELETE_VAR_CTX_HANDLER_METAS.put(uriTemplate, contextHandlerMeta);
                                continue block59;
                            }
                        }
                        TWO_SEG_OTHER_METHOD_VAR_CTX_HANDLER_METAS.put(uriTemplate, contextHandlerMeta);
                        continue block59;
                    }
                    case 3: {
                        switch (httpMethod) {
                            case "GET": {
                                THREE_SEG_GET_VAR_CTX_HANDLER_METAS.put(uriTemplate, contextHandlerMeta);
                                continue block59;
                            }
                            case "POST": {
                                THREE_SEG_POST_VAR_CTX_HANDLER_METAS.put(uriTemplate, contextHandlerMeta);
                                continue block59;
                            }
                            case "PUT": {
                                THREE_SEG_PUT_VAR_CTX_HANDLER_METAS.put(uriTemplate, contextHandlerMeta);
                                continue block59;
                            }
                            case "DELETE": {
                                THREE_SEG_DELETE_VAR_CTX_HANDLER_METAS.put(uriTemplate, contextHandlerMeta);
                                continue block59;
                            }
                        }
                        THREE_SEG_OTHER_METHOD_VAR_CTX_HANDLER_METAS.put(uriTemplate, contextHandlerMeta);
                        continue block59;
                    }
                    default: {
                        switch (httpMethod) {
                            case "GET": {
                                FOUR_MORE_SEG_GET_VAR_CTX_HANDLER_METAS.put(uriTemplate, contextHandlerMeta);
                                continue block59;
                            }
                            case "POST": {
                                FOUR_MORE_SEG_POST_VAR_CTX_HANDLER_METAS.put(uriTemplate, contextHandlerMeta);
                                continue block59;
                            }
                            case "PUT": {
                                FOUR_MORE_SEG_PUT_VAR_CTX_HANDLER_METAS.put(uriTemplate, contextHandlerMeta);
                                continue block59;
                            }
                            case "DELETE": {
                                FOUR_MORE_SEG_DELETE_VAR_CTX_HANDLER_METAS.put(uriTemplate, contextHandlerMeta);
                                continue block59;
                            }
                        }
                        FOUR_MORE_SEG_OTHER_METHOD_VAR_CTX_HANDLER_METAS.put(uriTemplate, contextHandlerMeta);
                    }
                }
            }
        }
        LOGGER.log(Level.DEBUG, "Added a processor method [" + methodName + "]");
    }

    private static RouteResolution route(String requestURI, String method, Map<String, ContextHandlerMeta> pathVarContextHandlerMetasHolder) {
        for (Map.Entry<String, ContextHandlerMeta> entry : pathVarContextHandlerMetasHolder.entrySet()) {
            String uriTemplate = entry.getKey();
            ContextHandlerMeta contextHandlerMeta = entry.getValue();
            Map<String, String> pathVars = UriTemplates.resolve(requestURI, uriTemplate);
            if (null == pathVars) continue;
            return new RouteResolution(contextHandlerMeta, pathVars, uriTemplate, method);
        }
        return null;
    }

    private String getHttpMethod(Request request) {
        String ret = (String)request.getAttribute("requestMethod");
        if (StringUtils.isBlank((CharSequence)ret)) {
            ret = request.getMethod();
        }
        return ret;
    }

    private String getRequestURI(Request request) {
        String ret = (String)request.getAttribute("requestURI");
        if (StringUtils.isBlank((CharSequence)ret)) {
            ret = request.getRequestURI();
        }
        return ret;
    }
}

