/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.latke.http;

import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.b3log.latke.Latkes;
import org.b3log.latke.http.Cookie;
import org.b3log.latke.http.Session;
import org.b3log.latke.http.WebSocketChannel;

public class WebSocketSession {
    String id;
    ChannelHandlerContext ctx;
    WebSocketChannel webSocketChannel;
    Session session;
    Set<Cookie> cookies = new HashSet<Cookie>();
    Map<String, String> params = new HashMap<String, String>();

    WebSocketSession(ChannelHandlerContext ctx) {
        this.ctx = ctx;
        this.id = RandomStringUtils.randomAlphanumeric((int)16);
    }

    public void sendText(String text) {
        this.ctx.writeAndFlush((Object)new TextWebSocketFrame(text));
    }

    public void close() {
        this.webSocketChannel.onClose(this);
        this.ctx.close();
    }

    public String getId() {
        return this.id;
    }

    public String getParameter(String name) {
        return this.params.get(name);
    }

    public Session getHttpSession() {
        return this.session;
    }

    public Set<Cookie> getCookies() {
        return this.cookies;
    }

    public void addCookie(Cookie cookie) {
        if (StringUtils.isBlank((CharSequence)cookie.getPath())) {
            cookie.setPath(Latkes.getContextPath());
        }
        if (StringUtils.isBlank((CharSequence)cookie.getPath())) {
            cookie.setPath("/");
        }
        this.cookies.add(cookie);
    }
}

