/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.latke.http;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.handler.codec.http.cookie.ServerCookieDecoder;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshakerFactory;
import io.netty.util.ReferenceCountUtil;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.apache.commons.lang3.StringUtils;
import org.b3log.latke.Latkes;
import org.b3log.latke.http.Cookie;
import org.b3log.latke.http.Dispatcher;
import org.b3log.latke.http.Session;
import org.b3log.latke.http.Sessions;
import org.b3log.latke.http.WebSocketChannel;
import org.b3log.latke.http.WebSocketSession;

final class WebSocketHandler
extends SimpleChannelInboundHandler<Object> {
    private WebSocketServerHandshaker handshaker;
    private WebSocketSession webSocketSession;
    private WebSocketChannel webSocketChannel;

    WebSocketHandler() {
    }

    protected void channelRead0(ChannelHandlerContext ctx, Object msg) {
        if (msg instanceof HttpRequest) {
            this.handleHttpRequest(ctx, (HttpRequest)msg);
        } else if (msg instanceof WebSocketFrame) {
            this.handleWebSocketFrame(ctx, (WebSocketFrame)msg);
        } else {
            ReferenceCountUtil.retain((Object)msg);
            ctx.fireChannelRead(msg);
        }
    }

    public void channelReadComplete(ChannelHandlerContext ctx) {
        ctx.flush();
    }

    private void handleHttpRequest(ChannelHandlerContext ctx, HttpRequest req) {
        if (this.isWebSocketRequest(req)) {
            WebSocketServerHandshakerFactory wsFactory = new WebSocketServerHandshakerFactory(req.uri(), null, true);
            this.handshaker = wsFactory.newHandshaker(req);
            if (this.handshaker == null) {
                WebSocketServerHandshakerFactory.sendUnsupportedVersionResponse((Channel)ctx.channel());
            } else {
                this.handshaker.handshake(ctx.channel(), req);
                this.webSocketSession = new WebSocketSession(ctx);
                QueryStringDecoder queryStringDecoder = new QueryStringDecoder(req.uri());
                Map params = queryStringDecoder.parameters();
                for (Map.Entry p : params.entrySet()) {
                    String key = (String)p.getKey();
                    List vals = (List)p.getValue();
                    for (String val : vals) {
                        this.webSocketSession.params.put(key, val);
                    }
                }
                this.handleCookie(req, this.webSocketSession);
                this.webSocketSession.webSocketChannel = this.webSocketChannel;
                CompletableFuture.completedFuture(this.webSocketSession).thenAcceptAsync(this.webSocketChannel::onConnect, (Executor)ctx.executor());
            }
        } else {
            ReferenceCountUtil.retain((Object)req);
            ctx.fireChannelRead((Object)req);
        }
    }

    private void handleCookie(HttpRequest req, WebSocketSession webSocketSession) {
        boolean secure = StringUtils.equalsIgnoreCase((CharSequence)Latkes.getServerScheme(), (CharSequence)"https");
        Session session = null;
        boolean enabledSession = Latkes.isEnabledSession();
        String cookieStr = req.headers().get(HttpHeaderNames.COOKIE.toString());
        if (StringUtils.isNotBlank((CharSequence)cookieStr)) {
            Set cookies = ServerCookieDecoder.STRICT.decode(cookieStr);
            for (io.netty.handler.codec.http.cookie.Cookie cookie : cookies) {
                if (!enabledSession) {
                    webSocketSession.addCookie(new Cookie(cookie));
                    continue;
                }
                if (cookie.name().equals("LATKE_SESSION_ID")) {
                    String cookieSessionId = cookie.value();
                    if (!Sessions.contains(cookieSessionId)) {
                        session = this.createSessionCookie(webSocketSession, secure);
                        continue;
                    }
                    session = Sessions.get(cookieSessionId);
                    Cookie c = new Cookie("LATKE_SESSION_ID", session.getId());
                    c.setHttpOnly(true);
                    c.setSecure(secure);
                    webSocketSession.addCookie(c);
                    continue;
                }
                webSocketSession.addCookie(new Cookie(cookie));
            }
        } else if (enabledSession) {
            session = this.createSessionCookie(webSocketSession, secure);
        }
        if (null == session && enabledSession) {
            session = this.createSessionCookie(webSocketSession, secure);
        }
        webSocketSession.session = session;
    }

    private Session createSessionCookie(WebSocketSession webSocketSession, boolean secure) {
        Session ret = Sessions.add();
        Cookie c = new Cookie("LATKE_SESSION_ID", ret.getId());
        c.setHttpOnly(true);
        c.setSecure(secure);
        webSocketSession.addCookie(c);
        return ret;
    }

    private void handleWebSocketFrame(ChannelHandlerContext ctx, WebSocketFrame frame) {
        if (frame instanceof CloseWebSocketFrame) {
            this.handshaker.close(ctx.channel(), (CloseWebSocketFrame)frame.retain());
            CompletableFuture.completedFuture(this.webSocketSession).thenAcceptAsync(this.webSocketChannel::onClose);
            return;
        }
        if (frame instanceof PingWebSocketFrame) {
            ctx.channel().write((Object)new PongWebSocketFrame(frame.content().retain()));
            return;
        }
        if (!(frame instanceof TextWebSocketFrame)) {
            UnsupportedOperationException throwable = new UnsupportedOperationException("Unsupported frame type [" + frame.getClass().getName() + "]");
            this.handshaker.close(ctx.channel(), new CloseWebSocketFrame());
            CompletableFuture.completedFuture(new WebSocketChannel.Error(throwable, this.webSocketSession)).thenAcceptAsync(this.webSocketChannel::onError, (Executor)ctx.executor());
            return;
        }
        CompletableFuture.completedFuture(new WebSocketChannel.Message(((TextWebSocketFrame)frame).text(), this.webSocketSession)).thenAcceptAsync(this.webSocketChannel::onMessage, (Executor)ctx.executor());
    }

    private boolean isWebSocketRequest(HttpRequest req) {
        String uri = StringUtils.substringBefore((String)req.uri(), (String)"?");
        this.webSocketChannel = Dispatcher.webSocketChannels.get(uri);
        return this.webSocketChannel != null && "Upgrade".equalsIgnoreCase(req.headers().get((CharSequence)HttpHeaderNames.CONNECTION)) && "WebSocket".equalsIgnoreCase(req.headers().get((CharSequence)HttpHeaderNames.UPGRADE));
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        if (null != this.webSocketSession && null != this.webSocketChannel) {
            CompletableFuture.completedFuture(new WebSocketChannel.Error(cause, this.webSocketSession)).thenAcceptAsync(this.webSocketChannel::onError, (Executor)ctx.executor());
        }
        ctx.close();
    }

    public void channelInactive(ChannelHandlerContext ctx) {
        if (null != this.webSocketSession && null != this.webSocketChannel) {
            CompletableFuture.completedFuture(this.webSocketSession).thenAcceptAsync(this.webSocketChannel::onClose);
        }
        ctx.fireChannelInactive();
    }
}

