/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.latke.http;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.cookie.ServerCookieDecoder;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.b3log.latke.Latkes;
import org.b3log.latke.http.Cookie;
import org.b3log.latke.http.Dispatcher;
import org.b3log.latke.http.Request;
import org.b3log.latke.http.RequestContext;
import org.b3log.latke.http.Response;
import org.b3log.latke.http.Session;
import org.b3log.latke.http.Sessions;
import org.b3log.latke.util.StaticResources;

final class ServerHandler
extends SimpleChannelInboundHandler<FullHttpRequest> {
    private static final Logger LOGGER = LogManager.getLogger(ServerHandler.class);

    ServerHandler() {
    }

    public void channelReadComplete(ChannelHandlerContext ctx) {
        ctx.flush();
    }

    protected void channelRead0(ChannelHandlerContext ctx, FullHttpRequest fullHttpRequest) {
        this.setSchemeHostPort(fullHttpRequest);
        Request request = new Request(ctx, fullHttpRequest);
        DefaultFullHttpResponse res = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
        Response response = new Response(ctx, (HttpResponse)res);
        response.setKeepAlive(HttpUtil.isKeepAlive((HttpMessage)request.req));
        if (!StaticResources.isStatic(request)) {
            request.parseQueryStr();
            String contentType = request.getHeader(HttpHeaderNames.CONTENT_TYPE.toString());
            if (StringUtils.isNotBlank((CharSequence)contentType)) {
                if (StringUtils.equalsIgnoreCase((CharSequence)(contentType = StringUtils.substringBefore((String)contentType, (String)";")), (CharSequence)"multipart/form-data")) {
                    request.parseFormData();
                } else {
                    request.parseForm();
                }
            } else {
                request.parseForm();
            }
            this.handleCookie(request, response);
        } else {
            request.setStaticResource(true);
        }
        RequestContext context = Dispatcher.handle(request, response);
        this.release(context);
    }

    private void setSchemeHostPort(FullHttpRequest fullHttpRequest) {
        HttpHeaders headers = fullHttpRequest.headers();
        if (null != headers) {
            String host;
            String scheme = headers.get("scheme");
            if (StringUtils.isNotBlank((CharSequence)scheme)) {
                Latkes.setScheme(scheme);
            }
            if (StringUtils.isNotBlank((CharSequence)(host = headers.get("host")))) {
                if (StringUtils.containsIgnoreCase((CharSequence)host, (CharSequence)":")) {
                    String name = StringUtils.split((String)host, (String)":")[0];
                    String port = StringUtils.split((String)host, (String)":")[1];
                    Latkes.setHost(name);
                    Latkes.setPort(port);
                } else {
                    Latkes.setHost(host);
                }
            }
        }
    }

    private void release(RequestContext context) {
        Request request = context.getRequest();
        if (null != request.httpDecoder) {
            request.httpDecoder.destroy();
        }
        Latkes.clearSchemeHostPort();
    }

    private void handleCookie(Request request, Response response) {
        boolean secure = StringUtils.equalsIgnoreCase((CharSequence)Latkes.getServerScheme(), (CharSequence)"https");
        Session session = null;
        boolean enabledSession = Latkes.isEnabledSession();
        String cookieStr = request.getHeader(HttpHeaderNames.COOKIE.toString());
        if (StringUtils.isNotBlank((CharSequence)cookieStr)) {
            Set cookies = ServerCookieDecoder.STRICT.decode(cookieStr);
            for (io.netty.handler.codec.http.cookie.Cookie cookie : cookies) {
                if (!enabledSession) {
                    request.addCookie(new Cookie(cookie));
                    continue;
                }
                if (cookie.name().equals("LATKE_SESSION_ID")) {
                    String cookieSessionId = cookie.value();
                    if (!Sessions.contains(cookieSessionId)) {
                        session = this.createSessionCookie(request, response, secure);
                        continue;
                    }
                    session = Sessions.get(cookieSessionId);
                    Cookie c = new Cookie("LATKE_SESSION_ID", session.getId());
                    c.setHttpOnly(true);
                    c.setSecure(secure);
                    request.addCookie(c);
                    response.addCookie(c);
                    continue;
                }
                request.addCookie(new Cookie(cookie));
                response.addCookie(new Cookie(cookie));
            }
        }
        if (null == session && enabledSession) {
            session = this.createSessionCookie(request, response, secure);
        }
        request.session = session;
    }

    private Session createSessionCookie(Request request, Response response, boolean secure) {
        Session ret = Sessions.add();
        Cookie c = new Cookie("LATKE_SESSION_ID", ret.getId());
        c.setHttpOnly(true);
        c.setSecure(secure);
        request.addCookie(c);
        response.addCookie(c);
        return ret;
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        ctx.close();
    }
}

