/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.latke.http;

import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.handler.codec.http.multipart.Attribute;
import io.netty.handler.codec.http.multipart.DefaultHttpDataFactory;
import io.netty.handler.codec.http.multipart.HttpDataFactory;
import io.netty.handler.codec.http.multipart.HttpPostRequestDecoder;
import io.netty.handler.codec.http.multipart.InterfaceHttpData;
import io.netty.util.CharsetUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.codec.binary.StringUtils;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.b3log.latke.Latkes;
import org.b3log.latke.http.Cookie;
import org.b3log.latke.http.FileUpload;
import org.b3log.latke.http.RequestContext;
import org.b3log.latke.http.Session;
import org.b3log.latke.util.URLs;
import org.json.JSONObject;

public class Request {
    private static final Logger LOGGER = LogManager.getLogger(Request.class);
    private static final HttpDataFactory HTTP_DATA_FACTORY = new DefaultHttpDataFactory(true);
    ChannelHandlerContext ctx;
    FullHttpRequest req;
    HttpPostRequestDecoder httpDecoder;
    RequestContext context;
    Map<String, String> params = new HashMap<String, String>();
    JSONObject json = new JSONObject();
    Map<String, Object> attrs = new HashMap<String, Object>();
    byte[] bytes;
    Map<String, List<FileUpload>> files = new HashMap<String, List<FileUpload>>();
    Set<Cookie> cookies = new HashSet<Cookie>();
    Session session;
    boolean staticResource;

    public Request(ChannelHandlerContext ctx, FullHttpRequest req) {
        this.ctx = ctx;
        this.req = req;
    }

    public String getHeader(String name) {
        return this.req.headers().get(name);
    }

    public String getMethod() {
        return this.req.method().name();
    }

    public void setMethod(String method) {
        this.req.setMethod(HttpMethod.valueOf((String)method));
    }

    public String getRequestURI() {
        String ret = this.req.uri();
        ret = org.apache.commons.lang3.StringUtils.substringBefore((String)ret, (String)"?");
        return ret;
    }

    public String getQueryString() {
        String ret = this.req.uri();
        return org.apache.commons.lang3.StringUtils.substringAfter((String)ret, (String)"?");
    }

    public String getString() {
        return StringUtils.newStringUtf8((byte[])this.bytes);
    }

    public void setBytes(byte[] bytes) {
        this.bytes = bytes;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public void setRequestURI(String uri) {
        this.req.setUri(uri);
    }

    public String getContentType() {
        return this.req.headers().get((CharSequence)HttpHeaderNames.CONTENT_TYPE);
    }

    public Iterator<String> getHeaderNames() {
        return this.req.headers().names().iterator();
    }

    public void setParameter(String name, String value) {
        this.params.put(name, value);
    }

    public String getParameter(String name) {
        return this.params.get(name);
    }

    public void setParams(Map<String, String> params) {
        this.params = params;
    }

    public Set<String> getParameterNames() {
        return this.params.keySet();
    }

    public void setJSON(JSONObject json) {
        this.json = json;
    }

    public JSONObject getJSON() {
        return this.json;
    }

    public Object getAttribute(String name) {
        return this.attrs.get(name);
    }

    public void setAttribute(String name, Object value) {
        this.attrs.put(name, value);
    }

    public String getRemoteAddr() {
        String ret = this.ctx.channel().remoteAddress().toString();
        if (org.apache.commons.lang3.StringUtils.startsWith((CharSequence)ret, (CharSequence)"/")) {
            ret = ret.substring(1);
        }
        return org.apache.commons.lang3.StringUtils.substringBeforeLast((String)ret, (String)":");
    }

    public String getScheme() {
        return "http";
    }

    public String getServerName() {
        return "localhost";
    }

    public int getServerPort() {
        return 8080;
    }

    public Set<Cookie> getCookies() {
        return this.cookies;
    }

    public void setCookies(Set<Cookie> cookies) {
        this.cookies = cookies;
    }

    public void addCookie(Cookie cookie) {
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)cookie.getPath())) {
            cookie.setPath(Latkes.getContextPath());
        }
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)cookie.getPath())) {
            cookie.setPath("/");
        }
        this.cookies.add(cookie);
    }

    public void addCookie(String name, String value) {
        Cookie cookie = new Cookie(name, value);
        this.addCookie(cookie);
    }

    public void setSession(Session session) {
        this.session = session;
    }

    public Session getSession() {
        return this.session;
    }

    public boolean isStaticResource() {
        return this.staticResource;
    }

    public void setStaticResource(boolean staticResource) {
        this.staticResource = staticResource;
    }

    public List<FileUpload> getFileUploads(String name) {
        return this.files.getOrDefault(name, Collections.emptyList());
    }

    public FileUpload getFileUpload(String name) {
        List<FileUpload> fileUploads = this.getFileUploads(name);
        if (fileUploads.isEmpty()) {
            return null;
        }
        return fileUploads.get(0);
    }

    void parseQueryStr() {
        this.parseAttrs(this.req.uri(), true);
    }

    void parseForm() {
        try {
            String content = this.req.content().toString(CharsetUtil.UTF_8);
            if (org.apache.commons.lang3.StringUtils.startsWithIgnoreCase((CharSequence)content, (CharSequence)"%7B")) {
                this.json = new JSONObject(URLs.decode(content));
            } else if (org.apache.commons.lang3.StringUtils.startsWithIgnoreCase((CharSequence)content, (CharSequence)"{")) {
                this.json = new JSONObject(content);
            } else {
                this.parseAttrs(content, false);
            }
            this.bytes = StringUtils.getBytesUtf8((String)content);
        }
        catch (Exception e) {
            LOGGER.log(Level.ERROR, "Parses request [uri=" + this.req.uri() + ", remoteAddr=" + this.getRemoteAddr() + ", body=" + this.bytes + "] failed: " + e.getMessage());
        }
    }

    void parseFormData() {
        try {
            this.httpDecoder = new HttpPostRequestDecoder(HTTP_DATA_FACTORY, (HttpRequest)this.req);
            this.httpDecoder.setDiscardThreshold(0);
            this.httpDecoder.offer((HttpContent)this.req);
            while (this.httpDecoder.hasNext()) {
                InterfaceHttpData data = this.httpDecoder.next();
                if (InterfaceHttpData.HttpDataType.FileUpload == data.getHttpDataType()) {
                    FileUpload fileUpload = new FileUpload();
                    fileUpload.fileUpload = (io.netty.handler.codec.http.multipart.FileUpload)data;
                    this.files.computeIfAbsent(fileUpload.getName(), k -> new ArrayList()).add(fileUpload);
                    continue;
                }
                Attribute attribute = (Attribute)data;
                this.params.put(attribute.getName(), attribute.getValue());
            }
        }
        catch (HttpPostRequestDecoder.EndOfDataDecoderException data) {
        }
        catch (Exception e) {
            LOGGER.log(Level.ERROR, "Parses request [uri=" + this.req.uri() + ", remoteAddr=" + this.getRemoteAddr() + ", body=" + this.bytes + "] failed: " + e.getMessage());
        }
    }

    private void parseAttrs(String paris, boolean hasPath) {
        QueryStringDecoder queryStringDecoder = new QueryStringDecoder(paris, hasPath);
        Map parameters = queryStringDecoder.parameters();
        for (Map.Entry p : parameters.entrySet()) {
            String key = (String)p.getKey();
            List vals = (List)p.getValue();
            for (String val : vals) {
                this.params.put(key, val);
            }
        }
    }
}

