/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.latke.http;

import java.lang.invoke.SerializedLambda;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.b3log.latke.Latkes;
import org.b3log.latke.http.HttpMethod;
import org.b3log.latke.http.Request;
import org.b3log.latke.http.RequestContext;
import org.b3log.latke.http.Response;
import org.b3log.latke.http.WebSocketChannel;
import org.b3log.latke.http.function.Handler;
import org.b3log.latke.http.handler.ContextHandlerMeta;
import org.b3log.latke.http.handler.InvokeHandler;
import org.b3log.latke.http.handler.RouteHandler;
import org.b3log.latke.http.handler.StaticResourceHandler;
import org.b3log.latke.http.renderer.AbstractResponseRenderer;
import org.b3log.latke.http.renderer.Http404Renderer;

public final class Dispatcher {
    private static final Logger LOGGER = LogManager.getLogger(Dispatcher.class);
    public static final List<Handler> HANDLERS = new ArrayList<Handler>();
    public static Handler startRequestHandler;
    public static Handler endRequestHandler;
    static Router errorHandleRouter;
    static Map<String, WebSocketChannel> webSocketChannels;
    static List<RouterGroup> routerGroups;

    public static RequestContext handle(Request request, Response response) {
        RequestContext ret;
        response.context = request.context = (ret = new RequestContext(request, response));
        ret.addHandlers(HANDLERS);
        if (null != startRequestHandler) {
            try {
                startRequestHandler.handle(ret);
            }
            catch (Exception e) {
                LOGGER.log(Level.ERROR, "Start request handle failed", (Throwable)e);
            }
        }
        ret.handle();
        Dispatcher.renderResponse(ret);
        if (null != endRequestHandler) {
            try {
                endRequestHandler.handle(ret);
            }
            catch (Exception e) {
                LOGGER.log(Level.ERROR, "End request handle failed", (Throwable)e);
            }
        }
        return ret;
    }

    public static void renderResponse(RequestContext context) {
        Response response = context.getResponse();
        if (response.isCommitted()) {
            return;
        }
        AbstractResponseRenderer renderer = context.getRenderer();
        if (null == renderer) {
            renderer = new Http404Renderer();
        }
        renderer.render(context);
    }

    public static void error(String uriTemplate, Handler handler, Handler ... middlewares) {
        RouterGroup group = Dispatcher.group();
        if (0 < ArrayUtils.getLength((Object)middlewares)) {
            group.middlewares.addAll(Arrays.asList(middlewares));
        }
        errorHandleRouter = group.get((String)uriTemplate, (Handler)handler).routers.get(0);
    }

    public static void webSocket(String uri, WebSocketChannel webSocketChannel) {
        webSocketChannels.put(Latkes.getContextPath() + uri, webSocketChannel);
    }

    public static RouterGroup group() {
        RouterGroup ret = new RouterGroup();
        routerGroups.add(ret);
        return ret;
    }

    public static void mapping() {
        for (RouterGroup group : routerGroups) {
            for (Router router : group.routers) {
                ContextHandlerMeta contextHandlerMeta = router.toContextHandlerMeta();
                RouteHandler.addContextHandlerMeta(contextHandlerMeta);
            }
        }
    }

    public static void get(String uriTemplate, Handler handler, Handler ... middlewares) {
        RouterGroup group = Dispatcher.newGroupBindMiddlewares(middlewares);
        group.get(uriTemplate, handler);
    }

    public static void post(String uriTemplate, Handler handler, Handler ... middlewares) {
        RouterGroup group = Dispatcher.newGroupBindMiddlewares(middlewares);
        group.post(uriTemplate, handler);
    }

    public static void put(String uriTemplate, Handler handler, Handler ... middlewares) {
        RouterGroup group = Dispatcher.newGroupBindMiddlewares(middlewares);
        group.put(uriTemplate, handler);
    }

    public static void delete(String uriTemplate, Handler handler, Handler ... middlewares) {
        RouterGroup group = Dispatcher.newGroupBindMiddlewares(middlewares);
        group.delete(uriTemplate, handler);
    }

    public static void options(String uriTemplate, Handler handler, Handler ... middlewares) {
        RouterGroup group = Dispatcher.newGroupBindMiddlewares(middlewares);
        group.options(uriTemplate, handler);
    }

    private static RouterGroup newGroupBindMiddlewares(Handler ... middlewares) {
        RouterGroup ret = Dispatcher.group();
        if (0 < ArrayUtils.getLength((Object)middlewares)) {
            ret.middlewares.addAll(Arrays.asList(middlewares));
        }
        return ret;
    }

    static {
        HANDLERS.add(new StaticResourceHandler());
        HANDLERS.add(new RouteHandler());
        HANDLERS.add(new InvokeHandler());
        webSocketChannels = new ConcurrentHashMap<String, WebSocketChannel>();
        routerGroups = new ArrayList<RouterGroup>();
    }

    public static class Router {
        private RouterGroup group;
        private final List<String> uriTemplates = new ArrayList<String>();
        private final List<HttpMethod> httpRequestMethods = new ArrayList<HttpMethod>();
        private Handler handler;
        private Method method;

        public void options(String uriTemplate, Handler handler) {
            this.options(new String[]{uriTemplate}, handler);
        }

        public void options(String[] uriTemplates, Handler handler) {
            this.options().uris(uriTemplates).handler(handler);
        }

        public void delete(String uriTemplate, Handler handler) {
            this.delete(new String[]{uriTemplate}, handler);
        }

        public void delete(String[] uriTemplates, Handler handler) {
            this.delete().uris(uriTemplates).handler(handler);
        }

        public void put(String uriTemplate, Handler handler) {
            this.put(new String[]{uriTemplate}, handler);
        }

        public void put(String[] uriTemplates, Handler handler) {
            this.put().uris(uriTemplates).handler(handler);
        }

        public void post(String uriTemplate, Handler handler) {
            this.post(new String[]{uriTemplate}, handler);
        }

        public void post(String[] uriTemplates, Handler handler) {
            this.post().uris(uriTemplates).handler(handler);
        }

        public void get(String uriTemplate, Handler handler) {
            this.get(new String[]{uriTemplate}, handler);
        }

        public void get(String[] uriTemplates, Handler handler) {
            this.get().uris(uriTemplates).handler(handler);
        }

        public Router uris(String[] uriTemplates) {
            for (String uriTemplate : uriTemplates) {
                this.uri(uriTemplate);
            }
            return this;
        }

        public Router uri(String uriTemplate) {
            if (!this.uriTemplates.contains(uriTemplate)) {
                this.uriTemplates.add(uriTemplate);
            }
            return this;
        }

        public Router get() {
            if (!this.httpRequestMethods.contains((Object)HttpMethod.GET)) {
                this.httpRequestMethods.add(HttpMethod.GET);
            }
            return this;
        }

        public Router post() {
            if (!this.httpRequestMethods.contains((Object)HttpMethod.POST)) {
                this.httpRequestMethods.add(HttpMethod.POST);
            }
            return this;
        }

        public Router delete() {
            if (!this.httpRequestMethods.contains((Object)HttpMethod.DELETE)) {
                this.httpRequestMethods.add(HttpMethod.DELETE);
            }
            return this;
        }

        public Router put() {
            if (!this.httpRequestMethods.contains((Object)HttpMethod.PUT)) {
                this.httpRequestMethods.add(HttpMethod.PUT);
            }
            return this;
        }

        public Router head() {
            if (!this.httpRequestMethods.contains((Object)HttpMethod.HEAD)) {
                this.httpRequestMethods.add(HttpMethod.HEAD);
            }
            return this;
        }

        public Router options() {
            if (!this.httpRequestMethods.contains((Object)HttpMethod.OPTIONS)) {
                this.httpRequestMethods.add(HttpMethod.OPTIONS);
            }
            return this;
        }

        public Router trace() {
            if (!this.httpRequestMethods.contains((Object)HttpMethod.TRACE)) {
                this.httpRequestMethods.add(HttpMethod.TRACE);
            }
            return this;
        }

        public Router handler(Handler handler) {
            this.handler = handler;
            Class<?> clazz = handler.getClass();
            try {
                Handler lambda = handler;
                Method m = clazz.getDeclaredMethod("writeReplace", new Class[0]);
                m.setAccessible(true);
                SerializedLambda sl = (SerializedLambda)m.invoke((Object)lambda, new Object[0]);
                String implClassName = sl.getImplClass().replaceAll("/", ".");
                Class<?> implClass = Class.forName(implClassName);
                this.method = implClass.getDeclaredMethod(sl.getImplMethodName(), RequestContext.class);
            }
            catch (Exception e) {
                LOGGER.log(Level.ERROR, "Found lambda method reference impl method failed", (Throwable)e);
            }
            return this;
        }

        ContextHandlerMeta toContextHandlerMeta() {
            ContextHandlerMeta ret = new ContextHandlerMeta();
            ret.setUriTemplates(this.uriTemplates.toArray(new String[0]));
            ret.setHttpMethods(this.httpRequestMethods.toArray(new HttpMethod[0]));
            ret.setInvokeHolder(this.method);
            ret.setHandler(this.handler);
            ret.setMiddlewares(this.group.middlewares);
            return ret;
        }
    }

    public static class RouterGroup {
        private final List<Handler> middlewares = new ArrayList<Handler>();
        private final List<Router> routers = new ArrayList<Router>();

        public RouterGroup middlewares(Handler handler, Handler ... handlers) {
            this.middlewares.add(handler);
            this.middlewares.addAll(Arrays.asList(handlers));
            return this;
        }

        public Router router() {
            Router ret = new Router();
            this.routers.add(ret);
            ret.group = this;
            return ret;
        }

        public RouterGroup options(String uriTemplate, Handler handler) {
            Router route = this.router();
            route.options(uriTemplate, handler);
            return route.group;
        }

        public RouterGroup delete(String uriTemplate, Handler handler) {
            Router route = this.router();
            route.delete(uriTemplate, handler);
            return route.group;
        }

        public RouterGroup put(String uriTemplate, Handler handler) {
            Router router = this.router();
            router.put(uriTemplate, handler);
            return router.group;
        }

        public RouterGroup get(String uriTemplate, Handler handler) {
            Router router = this.router();
            router.get(uriTemplate, handler);
            return router.group;
        }

        public RouterGroup post(String uriTemplate, Handler handler) {
            Router router = this.router();
            router.post(uriTemplate, handler);
            return router.group;
        }
    }
}

