/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.latke.cache.redis;

import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.b3log.latke.Latkes;
import org.b3log.latke.util.CollectionUtils;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;
import redis.clients.jedis.JedisSentinelPool;
import redis.clients.jedis.util.Pool;

public final class Connections {
    private static final Logger LOGGER = LogManager.getLogger(Connections.class);
    private static Pool<Jedis> pool;

    public static Jedis getJedis() {
        return (Jedis)pool.getResource();
    }

    static void shutdown() {
        pool.close();
    }

    private Connections() {
    }

    static {
        try {
            Latkes.RuntimeCache runtimeCache = Latkes.getRuntimeCache();
            if (Latkes.RuntimeCache.REDIS == runtimeCache) {
                JedisPoolConfig jedisPoolConfig = new JedisPoolConfig();
                int minConnCnt = Integer.parseInt(Latkes.getLocalProperty("redis.minConnCnt"));
                jedisPoolConfig.setMinIdle(minConnCnt);
                int maxConnCnt = Integer.parseInt(Latkes.getLocalProperty("redis.maxConnCnt"));
                jedisPoolConfig.setMaxTotal(maxConnCnt);
                String password = Latkes.getLocalProperty("redis.password");
                if (StringUtils.isBlank((CharSequence)password)) {
                    password = null;
                }
                long waitTime = Long.parseLong(Latkes.getLocalProperty("redis.waitTime"));
                jedisPoolConfig.setMaxWaitMillis(waitTime);
                String masterName = Latkes.getLocalProperty("redis.master");
                if (StringUtils.isNotBlank((CharSequence)masterName)) {
                    String[] sentinelArray = Latkes.getLocalProperty("redis.sentinels").split(",");
                    Set<String> sentinels = CollectionUtils.arrayToSet(sentinelArray);
                    pool = new JedisSentinelPool(masterName, sentinels, (GenericObjectPoolConfig)jedisPoolConfig, password);
                } else {
                    String host = Latkes.getLocalProperty("redis.host");
                    int port = Integer.parseInt(Latkes.getLocalProperty("redis.port"));
                    pool = new JedisPool((GenericObjectPoolConfig)jedisPoolConfig, host, port, 2000, password);
                }
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.ERROR, "Initializes redis connection pool failed", (Throwable)e);
        }
    }
}

