/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.latke.cache.guava;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import org.b3log.latke.cache.AbstractCache;
import org.json.JSONObject;

public final class GuavaCache
extends AbstractCache {
    private final Cache<String, JSONObject> cache;

    public GuavaCache(int expireSeconds) {
        super(expireSeconds);
        this.cache = CacheBuilder.newBuilder().expireAfterWrite((long)expireSeconds, TimeUnit.SECONDS).build();
    }

    @Override
    public boolean contains(String key) {
        return null != this.cache.getIfPresent((Object)key);
    }

    @Override
    public void put(String key, JSONObject value) {
        this.cache.put((Object)key, (Object)value);
    }

    @Override
    public void put(String key, JSONObject value, int expireSeconds) {
        throw new UnsupportedOperationException();
    }

    @Override
    public JSONObject get(String key) {
        return (JSONObject)this.cache.getIfPresent((Object)key);
    }

    @Override
    public void remove(String key) {
        this.cache.invalidate((Object)key);
    }

    @Override
    public void remove(Collection<String> keys) {
        this.cache.invalidateAll(keys);
    }

    @Override
    public void clear() {
        this.cache.invalidateAll();
    }

    @Override
    public int size() {
        return (int)this.cache.size();
    }
}

