import base64

from flask import Flask, request, render_template, send_file
import subprocess

app = Flask(__name__)


@app.route('/')
def index():
    return render_template('index.html')


@app.route('/upload', methods=['POST'])
def upload_file():
    if 'video' not in request.files:
        return 'No file uploaded.', 400
    ss = request.form['startTime']
    t = request.form['duration']
    file = request.files['video']
    if file.filename == '':
        return 'Filename is empty.', 400

    input_f = "/tmp/{}".format(file.filename)
    file.save(input_f)
    resp = gif_gen(input_f, ss, t)

    if resp["result"] == "ok":
        with open(resp["output"], "rb") as image_file:
            encodedImage = base64.b64encode(image_file.read())
        return {
            "results": str(encodedImage, 'utf-8')
        }

    return {
        "error": resp["output"]
    }, 400


def gif_gen(file_path, start_time, duration):
    try:
        cmd = ["/opt/function/code/ffmpeg", "-y", "-ss", start_time, "-t", duration, "-r", "15", "-accurate_seek",
               "-i", file_path, "-pix_fmt", "rgb24", "/tmp/output.gif"]

        subprocess.run(
            cmd, stdout=subprocess.PIPE, stderr=subprocess.PIPE, check=True)
        return {
            "result": "ok",
            "output": "/tmp/output.gif"
        }
    except Exception as e:
        return {
            "result": "failed",
            "output": str(e)
        }


if __name__ == '__main__':
    app.run(debug=True, port=8000, host="0.0.0.0")